/* main.c --
 test program for the kemo M104 output card
 Copyright 2002
 Lionel, trollhunter Bouchpan-Lerust-Juery <trollhunter@linuxfr.org>
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License as
 published by the Free Software Foundation; either version 2 of the
 License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.
 
 You should have received a copy of the GNU General Public License 
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/io.h>
#include "kemo-M104.h"

#define PORT_TO_TEST "lp1"

int
main ()
{
  int status, i;

   printf ("******************************************\n\n");
#ifdef STATIC
  printf ("\n\tTesting static library\n\n");
#endif /* NOT STATIC */
#ifdef SHARED
  printf ("\n\tTesting shared libray\n\n");
#endif
  printf("While the messages are displayed on screen\n");
  printf("have a look at your module\n");
  printf ("******************************************\n\n");
  printf ("resetting card\n");
  status = M104_reset (PORT_TO_TEST);
  printf ("all leds should be off on the M104 module\n");
  sleep (5);
  printf ("switching on all the leds\n");
  status = M104_open (PORT_TO_TEST, M104_ALL, NULL);
  printf ("all leds should be switched on on the M104 module\n");
  sleep (5);
  printf ("resetting M104 and switching odd leds\n");
  status = M104_reset (PORT_TO_TEST);
  printf ("leds 1 and 3 will be switched on\n");
  status = M104_open (PORT_TO_TEST, 1, 3, NULL);
  sleep (5);
  printf ("resetting M104 and switching even leds\n");
  status = M104_reset (PORT_TO_TEST);
  printf ("leds 2 and 4 will be switched on\n");
  status = M104_open (PORT_TO_TEST, 2, 4, NULL);
  sleep (5);
  status = M104_reset (PORT_TO_TEST);
  printf ("\n\nnow, four in a row one by one ;-)\n");
  
  for (i = 1; i < 5; i++)
    {
      status = M104_open (PORT_TO_TEST, i, 0);
      printf ("switching on led #%d ==> state %X\n", i, M104_check(PORT_TO_TEST));
      sleep (1);
    }
  printf ("\nand now the countdown ...\n\n");
  printf("curent state : %X\n", M104_check(PORT_TO_TEST));
  for (i = 4; i > 0; i--)
    {
      status = M104_close (PORT_TO_TEST, i, 0);
      printf ("switching off led #%d ==> state %X\n", i, M104_check(PORT_TO_TEST));
      sleep (1);
    }

   printf ("******************************************\n\n");
   printf("\n\tEnd of ");
#ifdef STATIC
  printf ("static");
#endif /* NOT STATIC */
#ifdef SHARED
  printf ("shared");
#endif
  printf(" library test\n\n");
  printf ("******************************************\n\n");
  return (0);  
}
















