
# under_chroot.sh : version Thu Apr 25 18:39:18 CEST 2002 by Yann Guidon
# This script corresponds to the LFS-BOOK's 6th chapter
# and works in a chroot'ed environment : this is why there are
# the following test !

echo ' [ starting under_chroot.sh ]'

if [ ! -d /usr/yglfs ]
then
  echo "/usr/yglfs doesn't exist"
  exit -1
fi

if [ "$LFS" != "" ]
then
  echo "\$LFS exists : this is not (yet) desired !"
  exit -1
fi

if [ "$YGLFS" != "" ]
then
  echo "\$YGLFS exists : this is not (yet) desired !"
  exit -1
fi

if [ "$( ls -A root_chroot )" != "" ]
then
  echo "/usr/yglfs/root_chroot is not empty"
  exit -1
fi

#if  [ -e /usr/yglfs/.step2 ]
#then
#  echo ' /usr/yglfs/.step2 exists : nothing to do'
#  exit
#fi

#if [ -e /bin/ps ]
#then
#  echo 'ps exists !'
##  exit -1
#  if [ -n "$( ps -A | grep -v "grep" | grep "chroot" )" ]
#   # if we don't remove grep, the command line will
#   # be counted and the result will be always true :-)
#  then
#    echo 'chroot found : ok'
#  else
#    echo 'sorry ! This file MUST be executed in a chroot-ed environment.'
#    exit -1
#  fi
#else
#  echo 'no ps command. assuming running under chroot.'
#fi

# Here comes a tough part, because compiling it 
# was _really_ difficult to do...
time /usr/yglfs/build_glibc.sh | tee /usr/yglfs/time_glibc.out 2>&1
# This part must be done before other environment variables
# are set and functions are defined. Otherwise, glibc hands at
# a time or another...

YGLFS=/usr/yglfs
cd $YGLFS
source message_functions.sh
YGLFS_LOGDIR=$YGLFS/log
if [ ! -d "$YGLFS_LOGDIR" ]
then
  mkdir -v -p $YGLFS_LOGDIR
fi
LFS_PKGS=$YGLFS/src/pkgs
LFS_CMD=$YGLFS/src/lfs-commands/chapter6
YGLFS_LOG=$YGLFS_LOGDIR/.yglfs_log.2
LFS=/

# cleanup of the glibc build
rm -rf tmp &&
mkdir tmp &&

############## MAKEDEV ##############
if [ -e /dev/MAKEDEV ]
then
  message_warning 'MAKEDEV already done.'
else
  cd /dev &&
  bzcat $LFS_PKGS/MAKEDEV-1.*.bz2 > MAKEDEV &&
  chmod 754 MAKEDEV &&
  ./MAKEDEV -v generic &&
  message_ok 'MAKEDEV ok'
fi &&

# fix the man|man-pages basename collision :
cd $LFS_PKGS &&
if [ ! -L man-progs-1.5j.tar.bz2 ]
then
  message_warning "creating symlink for man-1.5j.tar.bz2"
  ln -s man-1.5j.tar.bz2 man-progs-1.5j.tar.bz2
fi &&
# WARNING ! the basename collision is package-specific !
# if the package changes, the script must be changed...

# build the whole damn rest :
BASENAME_LIST="man-pages findutils gawk ncurses nano \
 gcc bison less groff man-progs perl m4 texinfo\
 autoconf automake bash flex file libtool bin86\
 binutils bzip2 ed gettext kbd diffutils e2fsprogs \
 fileutils grep gzip make modutils netkit-base \
 patch procinfo procps psmisc sed sh-utils net-tools \
 shadow sysklogd sysvinit tar textutils util-linux" &&
message_warning 'starting install_functions.sh' &&
source $YGLFS/install_functions.sh &&

# lilo is removed from the list, loadlin is used instead from DOS
# vim is also removed, nano is used instead.

# additional scripts :

source $LFS_CMD/bsdinit-fr-0.0 &&

#if [ ! -e /root/.vimrc ]
#then
#  source $LFS_CMD/configure-vim &&
#  mv /root/.vimrc /etc &&
#  chmod 755 /etc/.vimrc &&
#  ln -s /etc/.vimrc /root/.vimrc &&
#  message_warning '/etc/vimrc created'
#fi &&

if [ ! -L /etc/localtime ]
then
  source $LFS_CMD/configure-glibc-fr &&
  message_warning "glibc/nss configured"
fi &&
if [ ! -e /etc/ld.so.conf ]
then
  source $LFS_CMD/configure-ld.so &&
  message_warning "/etc/ld.so.conf created"
fi &&
if [ ! -e /etc/syslog.conf ]
then
  source $LFS_CMD/configure-sysklogd &&
  message_warning "/etc/syslog.conf created"
fi &&
if [ ! -e /etc/defkeymap.map ]
then
  cp $LFS_CMD/defkeymap.map /etc &&
  if [ ! -e /usr/share/kbd/keymaps ]
  then
    mv /usr/share/kbd/keymaps /usr/share/kbd/keymaps.renamed
  fi &&
  message_warning "keymap configured."
fi &&
if [ ! -e /var/run/utmp ]
then
  source $LFS_CMD/create-utmp-wtmp-btmp
  message_warning 'utmp created'
fi || message_warning ' =oooooooopps= '

if [ -e /usr/yglfs/fstab ]
then
  cp /usr/yglfs/fstab /etc/fstab
fi

if [ ! -e /etc/fstab ]
then
  cat > /etc/fstab << "EOF"
# Begin /etc/fstab

# default :
# filesystem   mount-point fs-type    options     dump    fsck-order
/dev/*LFS*     /           *fs-type*  defaults    1       1
/dev/*LFS*     /           *fs-type*  defaults    1       1
/dev/*LFS*     /cd         *fs-type*  defaults    1       1
/dev/*swap*    swap        swap       pri=1       0       0
proc           /proc       proc       defaults    0       0
devpts         /dev/pts    devpts     gid=4,mode=620 0    0
usbdevfs       /proc/bus/usb usbdevfs defaults    0       0

#tower:
#/dev/hdb3       /       ext2    defaults 1 1
#/dev/cdrom      /media/cdrom    auto    ro,noauto,user,exec 0 0
#/dev/hda1       /rack/c auto    noauto,user 0 0
## /dev/hda3       /rack/ auto    noauto,user 0 0
#/dev/hda5       /rack/boot      auto    noauto,user 0 0
#/dev/hda6       /rack/  auto    noauto,user 0 0
##/dev/hda7      /rack/usr       auto    noauto,user 0 0
#devpts  /dev/pts        devpts  defaults 0 0
#/dev/hdc11      /home   ext2    defaults 1 2
#/dev/fd0        /media/floppy   auto    noauto,user,sync 0 0
#/dev/hdc10      /opt    ext2    defaults 1 2
#proc    /proc   proc    defaults 0 0
#/dev/hdc9       /usr    ext2    defaults 1 2
#/dev/hdb1       /windows/C      vfat    noauto,user,exec,suid 0 0
#/dev/hdb5       /windows/D      vfat    noauto,user,exec,suid 0 0
#/dev/hdb6       /windows/E      vfat    noauto,user,exec,suid 0 0
#/dev/hdc1       /windows/F      vfat    noauto,user,exec,suid 0 0
#/dev/hdc5       /windows/G      vfat    noauto,user,exec,suid 0 0
#/dev/hdc6       /windows/H      vfat    noauto,user,exec,suid 0 0
#/dev/hdc7       /windows/I      vfat    noauto,user,exec,suid 0 0
#/dev/hdc8       /windows/J      vfat    noauto,user,exec,suid 0 0

#laptop:
/dev/sda    /floppy       auto     noauto,user,exec,suid  0 0
#/dev/hda1  /c            vfat     noauto,user,exec,suid  0 0
#none       /proc         proc     defaults               0 0
#none       /dev/pts      devpts   gid=5,mode=620         0 0
#usbdevfs   /proc/bus/usb usbdevfs user,exec,suid         0 0
#/dev/hda5  swap          swap     defaults               0 0
#/dev/cdrom /cd           iso9660  noauto,owner,ro        0 0

# End /etc/fstab
EOF
  message_ok ' ##### /etc/fstab created ! please update it !!! ##### '
fi &&

if [ ! -e /usr/bin/updatedb.renamed ]
then
  cd /usr/bin &&
  mv updatedb updatedb.renamed &&
  message_ok 'updatedb renamed' &&
  cat > updatedb << "EOF"
#!/bin/bash
/usr/bin/updatedb.renamed --prunepaths='/proc'
EOF
chmod 755 updatedb
fi

message_ok ' -------- Chapter 7 is finished ! -------- ' \
 || message_ko ' *oooooooopps* '

if [ ! -e /usr/yglfs/.strip.out ]
then
  find $LFS/{,usr/,usr/local/}{bin,sbin,lib} -type f \
   -exec /usr/bin/strip -v --strip-debug '{}' ';' > /usr/yglfs/.strip.out 2>&1 &&
  message_ok 'strip performed.' || message_ko 'strip failed, check /usr/yglfs/.strip.out'
fi &&

if [ ! -e /usr/src/linux-lfs/.make_proper.out ]
then
  message_warning "now unpacking the kernel"
  cd /usr/src &&
  mkdir linux-lfs &&
  ln -s linux-lfs linux &&  
  tar xjvf $LFS_PKGS/linux-2.*.tar.bz2 > .tar.out &&
  cd linux &&
  message_warning "now patching the kernel" &&
  bzcat $LFS_PKGS/linux-*.patch.bz2 | patch -Np1 > ../.patch.out &&
  message_warning "make mrproper" &&
  make mrproper > .make_proper.out &&
  message_warning 'now proceed to the kernel setup'
fi && # || message_ko ' *oooooooopps* when unpacking the kernel '

cat > /usr/src/make_kernel.sh << EOF
make dep &&
make bzImage &&
make modules &&
make modules_install &&
cp /c/l.knl /c/backup.knl
cp /c/l.cnf /c/backup.cnf
cp arch/i386/boot/bzImage /c/l.knl &&
vidmode /c/l.knl 788
cp .config /c/l.cnf &&
echo "   ok ! "
EOF

#At this point, a k.configure file can be inserted.
if [ ! -e /dev/null ]
#if [ ! -e /usr/yglfs/log/.yglfs_kernel ]
then
  cd /usr/src/linux/ &&
  if [ ! -e .config ]
  then
    if [ -e /usr/yglfs/k.config ]
    then
      cp /usr/yglfs/k.config ./.config &&
      message_warning 're-using /usr/yglfs/k.config for .config'
    else
#      message_ko ''
      make menuconfig &&
      touch .make.old_config.out &&
      message_warning 'please save .config to /usr/yglfs/k.config !'
    fi
  fi &&
  if [ ! -e .make.old_config.out ]
  then
    message_warning "make_oldconfig" &&
    make oldconfig > .make.old_config.out &&
    rm -f .make.dep.out
  else
    message_warning "skipping make_oldconfig"
  fi &&
  if [ ! -e .make.dep.out ]
  then
    message_warning "make_dep" &&
    make dep > .make.dep.out &&
    rm -f .make.bzImage.out
  else
    message_warning "skipping make_dep"
  fi &&
  if [ ! -e .make.bzImage.out ]
  then
    message_warning "make_bzImage" &&
    make bzImage > .make.bzImage.out &&
    rm -f .make.modules.out
  else
    message_warning "skipping make_bzImage"
  fi &&
  if [ ! -e .make.modules.out ]
  then
    message_warning "make_modules" &&
    make modules > .make.modules.out &&
    rm -f .make.modules_install.out
  else
    message_warning "skipping make_modules"
  fi &&
  if [ ! -e .make.modules_install.out ]
  then
    message_warning "make_modules_install" &&
    make modules_install > .make.modules_install.out
  else
    message_warning "skipping make_modules_install"
  fi &&
#  message_warning "copying images" &&
  cp arch/i386/boot/bzImage /boot/lfskernel &&
#  cp System.map /boot &&
#  ln -s /lib/modules/2.4.19-pre7 /lib/modules/current &&
  touch /usr/yglfs/log/.yglfs_kernel
else
  message_warning 'skipping kernel compilation.'
fi || message_ko ' *oooooooopps* when compiling the kernel '

#if [ ! -e /etc/lilo.conf ]
#then
#  message_warning 'creating /etc/lilo.conf'
#  cat > /etc/lilo.conf << "EOF"
## /etc/lilo.conf
## This is an example LILO configuration file
#boot = /dev/hda?
#delay = 50
#prompt
##  vga = ASK # Let user enter the desired modes
#vga = 792    # You need to do this so it boots up in a sane state
#
#
## Linux bootable partition config begins
#image = /boot/lfskernel
#  append = "video=matrox:vesa:0318" # then switch to Matroxfb
#  root = /dev/hda?
#  label = LinuxMatrox
#  read-only 
#image = /boot/lfskernel
#  root = /dev/hda?
#  label = LinuxDefault
#  read-only
#
##tower :
##boot    = /dev/hdb1
##vga     = normal
##read-only
##menu-scheme = Wg:kw:Wg:Wg
##prompt
##timeout = 50
##message = /boot/message
##root   = /dev/hdb3
##
##other  = /dev/hdb1
## label  = d
##
##image  = /boot/vmlinuz
## label  = l
## initrd = /boot/initrd
#
#EOF
#fi &&

touch $YGLFS/.step2 &&
message_ok 'end of under_chroot.sh' || message_ko ' *oooooooopps*  (final part of the script) '

echo
echo '  DO NOT FORGET TO :'
echo '      - compile the kernel'
echo '      - update the fstab, lilo.conf, rc.d and other config files'
echo '      - check /dev (usb, fb, hid, hci...)'
echo '      - check the network'
echo '      - change the root passwd'
echo '      - check  the kernel configuration'
echo '      - reboot with the new HDD and run LILO/make the HDD bootable'
echo
echo '  other applications are compiled in the new system'
echo '  by running the "otherapps.sh" script.'
echo
