/*
This simple piece of code simply turns your ix86 into a i586 -
useful if you're cross-compiling for a weaker platform.

Compile with: gcc -I/usr/src/linux/include -c -DMODULE uname_i586.c
and then: insmod ./uname_i586.o

Revision : whygee@f-cpu.org, Wed Apr 10 07:45:11 CEST 2002 :
   added the UNAME_DUMB_STEPPING parameter/ifdef so the user can
   modify it at compile time. it's just a quick hack.
   your command line for simulating a 486 will look like :
	gcc -I/usr/src/linux/include -c -DMODULE \
		-DUNAME_DUMB_STEPPING uname_i586.c

*/

#include <linux/module.h>
#include <linux/utsname.h>

#ifndef UNAME_DUMB_STEPPING
#define UNAME_DUMB_STEPPING '5';
/* #error "no stepping specified." */
#endif

char save;

int init_module( void )
{
    save = system_utsname.machine[1];
    system_utsname.machine[1] = UNAME_DUMB_STEPPING;
    return( 0 );
}

void cleanup_module( void )
{
    system_utsname.machine[1] = save;
}
