
# install_functions : created by Yann Guidon <whygee@f-cpu.org> from
# make_base.sh, created by Yann Guidon <whygee@f-cpu.org> april, 10th 2002
# this script somewhat automates the operations that install a LFS-like
# linux system. 

# version Thu Apr 25 16:29:46 CEST 2002 : separating the common functions
# from the main scripts. They become somewhat less heavy. They only
# need to be sources with the correct options (environment variables)
# set, and they do the work. This way, the same piece of code
# can be called from chapter 5, 6 and later.

VAR_LIST="SETCOLOR_SUCCESS YGLFS LFS YGLFS_LOGDIR LFS_PKGS LFS_CMD BASENAME_LIST"

# check if all the necessary custom settings are done :
for VAR_LOOP in $VAR_LIST
do
  TEMP_VAR=${!VAR_LOOP}
  if [ -z "$TEMP_VAR" ]
  then
    echo '  error ! $VAR_LOOP not set !'
    exit -1
  fi
done

###################################
# At this stage, we should check
# whether all the required source
# packages are ok, shouldn't we ?
###################################

for BASENAME in $BASENAME_LIST
do
  if [ -z "$( ls $LFS_PKGS/$BASENAME* )" ]
  then
    message_ko "no source package for $BASENAME in $LFS_PKGS/"
  fi
  if [ -z "$( ls $LFS_CMD/$BASENAME* )" ]
  then
    message_ko "no command file for $BASENAME in $LFS_CMD/"
  fi
done

#################################################
# And now, proceed to the main install stuff ...
#################################################


function build_error () {
  echo "error : $*" > $YGLFS_LOGDIR/error_$BASENAME
  message_ko "$BASENAME failed ( $* )"
}

function uncompact_sources () {
  for FILENAME in $LFS_PKGS/$BASENAME-*
  do
    case $FILENAME in

      *.tar.gz|*.tgz)
        message_warning "gunzip/untar $FILENAME"
        tar xvzf $FILENAME >> .tar_output || build_error "$FILENAME failed"
        ;;

      *.tar.bz2|*.tar.bz|*.tbz|*.tbz2)
        message_warning "bunzip/untar $FILENAME"
        tar xvjf $FILENAME >> .tar_output || build_error "$FILENAME failed"
        ;;

      *.tar)
        message_warning "untar $FILENAME"
        tar xvf $FILENAME >> .tar_output || build_error "$FILENAME failed"
        ;;

      *.bz2)
          # usually a patch.
          # bunzip replaces the source file so i just symlink it
          # before doing the decompression. I could have used bzcat
          # but i don't know how to remove the .bz2 extension with bash :-/
        {
          message_warning "bunzip $FILENAME"
          ln -s $FILENAME . &&
          bunzip2 -f ./$BASENAME-*.bz2
        } || build_error "$FILENAME failed"
        ;;
            
      *)
        build_error "format of file $FILENAME is not recognized"
        ;;

    esac 
  done
}

################ the most important thing comes here : ################
function make_package () {
  if [[ -e $YGLFS_LOGDIR/error_$BASENAME || ! -e $YGLFS_LOGDIR/output_$BASENAME ]]
  then
    {
      rm -f $YGLFS_LOGDIR/error_$BASENAME &&  # remove the flag
      cd $YGLFS/tmp &&

#check if directory is empty and if tag is present
      if [ ! -e .tag_sources_ok ]
      then
        rm -f .tar_output &&
        uncompact_sources &&
        touch .tag_sources_ok
      else
        message_warning "$BASENAME already decompressed : skipping"
      fi
    } ||build_error "source archive can't be used"

# trying to detect if there is exactly 1 uncompressed directory
    {
      # search in tar's log for directories :
      DIRNAME=$( sed -e 's/^[.]\///' .tar_output | \
                 cut -d / -f 1 | \
                 uniq | tee .wc_in )
      # "sed, c'est dien !" :-)
      # sed removes the leading "./" because packages like fileutils
      # include them in the tar tree...

      # wc is a bitch because it adds leading spaces to the result...
      if [ $( cat .wc_in | wc -l ) == 1 ]
      then
        message_debug "source directory is $DIRNAME"
      else
        build_error "can't detect a source directory in $DIRNAME "
      fi &&

      WHOLEDIRNAME=$YGLFS/tmp/$DIRNAME  &&

      # verify that the absolute path exists anyway
      if [ ! -d $WHOLEDIRNAME ]
      then
        build_error "the directory $DIRNAME is not found"
      fi &&
      message_debug "going to $WHOLEDIRNAME" &&
      cd $WHOLEDIRNAME &&

# recognize the glibc version :
#      if [ -e $LFS_CMD/$BASENAME-*glibc* ]
# some stuff remains to be written here
# this is left to the user who should rename
# the apropriate files.


# executing the script :
      SCRIPTNAME=$(ls $LFS_CMD/$BASENAME-* | head -n1 ) &&
      if [ -z "$SCRIPTNAME" ]
      then
        build_error "the file $SCRIPTNAME is not found"
      fi &&
      message_warning "now sourcing $SCRIPTNAME" &&
      source $SCRIPTNAME >> $YGLFS_LOGDIR/output_$BASENAME 2>&1
    } || build_error "script doesn't pass."

# post-install stuff :
    {
      cd $YGLFS &&  # go there because tmp will be erased.
      case $BASENAME in

        bash)
          message_debug "testing link"
          if [ ! -L $LFS/bin/sh ]
          then
            build_error "$LFS/bin/sh is not a link"
          fi
          ;;

        fileutils)
          message_debug "testing ls"
          $LFS/bin/ls > /dev/null || build_error "$LFS/bin/ls failed"
          ;;

        *) 
          # default -> nothing
          ;;

      esac &&
      touch $YGLFS_LOGDIR/output_$BASENAME &&
      rm -rf $YGLFS/tmp &&  # major cleanup.
      mkdir $YGLFS/tmp &&
      message_ok "$BASENAME completed at $(date)"
    } || build_error "post-install failed"
  else
    message_warning "skipping $BASENAME : already done"
  fi
}  

if [ "$YGLFS_NOWARNING" == "" ]
then
  echo "Now if a build fails, check the corresponding output
files located in $YGLFS_LOGDIR to track the error and correct it.
You should be able to re-run this script later. Good luck."
fi

for BASENAME in $BASENAME_LIST
do
  make_package
done
# ahah, you didn't think this program was so simple ? :-)
