#!/bin/bash

# enter_chroot.sh, created by Yann Guidon <whygee@f-cpu.org> april, 15th 2002
# this script somewhat automates the operations that install a LFS-like
# linux system. This particular script corresponds to the chapter 6
# of the Linux From Scratch book (hi to Gerard Beekmans and the other LFSers)

# version : initial (0.0) Mon Apr 15 11:06:39 CEST 2002
#   based on make_base.sh, trying to setup and detect things
#   (fortunately there is much code to reuse, now :-D)
# version : Thu Apr 25 20:53:07 CEST 2002 : now more elaborated.


# colors and message functions :
source message_functions.sh ||exit -1

# creates a time stamp
message_ok "# YGLFS : enter_chroot.sh started " $(date)

# check if custom settings are done :
if [ "$YGLFS" == "" ]
then
  export YGLFS=/LFS
# please update this line if it changes (could also become
# a command line parameter)
#   Mon Apr 15 00:57:38 CEST 2002 => should become /usr/yglfs !
  message_warning "setting \$YGLFS to $YGLFS"
else
  message_warning "\$YGLFS is already set to $YGLFS"
  if [[ $YGLFS != /* ]]
  then
    message_ko "\$YGLFS is not an absolute path"
  fi
fi

export LFS=$YGLFS/root_chroot

if [ ! -d $LFS ]
then
  mesage_ko "did you forget ./cp_chroot.sh ?"
fi

# then check that our directories exist :
for MISSING_DIR in \
   $YGLFS/src/pkgs \
   $YGLFS/src/uname-trick \
   $YGLFS/src/lfs-commands/chapter6 \
   $YGLFS/log \
   $LFS \
   $LFS/usr \
   $LFS/usr/yglfs \
   $LFS/usr/yglfs/src \
   $LFS/usr/yglfs/src/pkgs \
   $LFS/usr/yglfs/src/lfs-commands
do
  if [[ ! -d $MISSING_DIR ]]
  then
    message_ko "$MISSING_DIR is missing. Did you run make_base.sh ? "
  fi
done

# the log directory :
export YGLFS_LOGDIR=$YGLFS/log

# now that the log directory is setup, we can send the log messages there.
export YGLFS_LOG=$YGLFS_LOGDIR/.yglfs_log.2
message_warning "setting our working directory to $YGLFS"

for MISSING_FILE in \
   $YGLFS/log/.yglfs_log.1 \
   $LFS/etc/group \
   $LFS/etc/passwd \
   $LFS/bin/sh \
   $LFS/bin/ls \
   $LFS/usr/yglfs/.step1 \
   $LFS/usr/yglfs/under_chroot.sh \
   $LFS/usr/yglfs/install_functions.sh \
   $LFS/usr/yglfs/message_functions.sh
do
  if [[ ! -e $MISSING_FILE ]]
  then
    message_ko "$MISSING_FILE is missing. Did you #really# run make_base.sh ? "
  fi
done

####### for future use : ########
#if [ -e $LFS/usr/yglfs/.step2 ]
#then
#  message_ok "STEP 2 already performed in $LFS : nothing to do !"
#  exit
#fi

####################### Here we go again ! ############################

chown root.root $LFS/proc || message_ko "can't chown $LFS/proc"

if [ "$( mount | grep $LFS/proc )" == "" ]
then
  message_warning "mounting $LFS/proc"
  mount proc $LFS/proc -t proc || message_ko "can't mount $LFS/proc"
fi

if [ ! -e $LFS/root/.bash_profile ]
then
  message_warning "creating $LFS/root/.bash_profile"
  cat > $LFS/root/.bash_profile << "EOF"
# Begin /root/.bash_profile
echo " [ sourcing /root/.bash_profile ]"
PS1='\u:\w\$ '
PATH=/bin:/usr/bin:/sbin:/usr/sbin
LS_OPTIONS='-a -N --color=tty -T 0'
TZ='Europe/Paris'
export PS1 PATH LS_OPTIONS TZ
export DEBUG_YGLFS=on
alias l='ls -al'
alias q='exit'
alias ls='ls $LS_OPTIONS'

# End /root/.bash_profile
EOF

fi

# uname stuff : it's used to cross-compile to a different target
# by inserting a kernel module that mimicks a different setting.
if [ -x $YGLFS/src/uname-trick/commands.auto ]
then
  cd $YGLFS/src/uname-trick/
  source commands.auto install
  cd $YGLFS
fi

####### And now, ....... let's _really_ go ! #########

cd $LFS &&
chroot $LFS /usr/bin/env -i HOME=/root TERM=$TERM /bin/bash --login /usr/yglfs/under_chroot.sh

######################################################

if [ -x $YGLFS/src/uname-trick/commands.auto ]
then
  cd $YGLFS/src/uname-trick/
  source commands.auto remove
  cd $YGLFS
fi

if [ "$( mount | grep $LFS/proc )" != "" ]
then
  message_warning "umounting $LFS/proc"
  umount $LFS/proc || message_ko "can't unmount $LFS/proc"
fi

message_ok "Back from the chroot'ed session."

exit
