# build_glibc.sh created whygee@f-cpu.org
# version Mon Apr 22 08:28:36 CEST 2002
# version Wed Apr 24 06:53:57 CEST 2002 : this should be ok now.
# version Thu Apr 25 14:32:01 CEST 2002 : allowing some more customisation

GLIBC_PREFIX=glibc-2.2.5
GLIBC_FILE_SRC=/usr/yglfs/src/pkgs/$GLIBC_PREFIX.tar.bz2
GLIBC_ADDON=/usr/yglfs/src/pkgs/glibc-linuxthreads-2.2.5.tar.bz2

if [ ! -e $GLIBC_FILE_SRC ]
then
  echo ' ERROR !!!  $GLIBC_FILE_SRC doesn't exist !!!'
  exit -1
fi

if [ ! -e $GLIBC_ADDON ]
then
  echo ' ERROR !!!  $GLIBC_ADDON doesn't exist !!!'
  exit -1
fi

echo 'chroot_cmds started.' &&
if [ ! -e /dev/null ]
then
  echo 'creating /dev/null'
  mknod -m 0666 /dev/null c 1 3 
else
  echo ' /dev/null already exists'
fi &&
cd / &&
chown 0.0 . proc &&
chown -R 0.0 bin boot dev etc home lib mnt opt root sbin tmp usr var &&
if [ ! -e /etc/mtab ]
then
  ln -s /proc/mounts /etc/mtab &&
  touch /etc/ld.so.conf
else
  echo ' /etc/mtab already exists'
fi &&

mkdir -p /usr/yglfs/log
if [ ! -e /usr/yglfs/log/.touch_glibc ]
then
  mkdir -p /usr/yglfs/tmp &&
  cd /usr/yglfs/tmp &&
  if [ ! -e glibc-build ]
  then
    echo " [ bunzip $GLIBC_FILE_SRC ]" &&
    tar xjvf $GLIBC_FILE_SRC > .tar_out_1 &&
    cd $GLIBC_PREFIX &&
    echo " [ bunzip $GLIBC_ADDON ]" &&
    tar xjvf $GLIBC_ADDON  > ../.tar_out_2 &&
    cp malloc/Makefile malloc/Makefile.backup &&
    sed 's%\$(PERL)%/usr/bin/perl%' malloc/Makefile.backup > malloc/Makefile &&
    cp login/Makefile login/Makefile.backup &&
    sed 's/root/0/' login/Makefile.backup > login/Makefile &&
    mkdir -p ../glibc-build
  fi &&
  cd /usr/yglfs/tmp/glibc-build &&
  ../$GLIBC_PREFIX/configure --prefix=/usr --enable-add-ons --libexecdir=/usr/bin > /usr/yglfs/tmp/.out_configure &&
  echo "cross-compiling = no" > configparms &&
  echo ' [ make ]' &&
  make > /usr/yglfs/tmp/.out_make &&
  echo ' [ make install ]' &&
  make install > /usr/yglfs/tmp/.out_make_install &&
  echo '==> make locales.' &&
  mkdir -p /usr/lib/locale/fr_FR &&
  localedef -i fr_FR -f ISO-8859-1 fr_FR &&
  # make localedata/install-locales > /usr/yglfs/tmp/.out_make_locale &&
  echo ' [ ********** glibc finished ********** ]' &&
  touch /usr/yglfs/log/.touch_glibc 
else
  echo ' glibc already done.'
fi &&

echo ' [ end of build_glibc.sh ]'
