#!/bin/sh

# rc.pcmcia 1.39 2001/10/04 12:30:05 (David Hinds)
#
# This is designed to work in BSD as well as SysV init setups.  See
# the HOWTO for customization instructions.

# Tags for Red Hat init configuration tools
#
# chkconfig: 2345 45 96
# processname: cardmgr
# pidfile: /var/run/cardmgr.pid
# config: /etc/pcmcia/config
# config: /etc/pcmcia/config.opts
# description: PCMCIA support is usually to support things like ethernet \
#              and modems in laptops.  It won't get started unless \
#              configured so it is safe to have it installed on machines \
#              that don't need it.

# Save option values passed in through the environment
for N in PCMCIA PCIC PCIC_OPTS CORE_OPTS CARDMGR_OPTS SCHEME ; do
    V=`eval echo '$'$N` ; if [ "$V" ] ; then eval ENV_$N=\"$V\" ; fi
done

# Source PCMCIA configuration, if available
if [ -f /etc/pcmcia.conf ] ; then
    # Debian startup option file
    . /etc/pcmcia.conf
elif [ -f /etc/sysconfig/pcmcia ] ; then
    # Red Hat startup option file
    . /etc/sysconfig/pcmcia
else
    # Slackware startup options go right here:
    # Should be either i82365 or tcic
    PCIC=i82365
    # Put socket driver timing parameters here
    PCIC_OPTS=
    # Put pcmcia_core options here
    CORE_OPTS=
    # Put cardmgr options here
    CARDMGR_OPTS=
    # To set the PCMCIA scheme at startup...
    SCHEME=
fi
for N in PCMCIA PCIC PCIC_OPTS CORE_OPTS CARDMGR_OPTS SCHEME ; do
    V=`eval echo '$'ENV_$N` ; if [ "$V" ] ; then eval $N=\"$V\" ; fi
done
if [ "$PCMCIA" -a "$PCMCIA" != "yes" ] ; then exit 0 ; fi

usage()
{
    echo "Usage: $0 {start|stop|status|restart|reload}"
}

cleanup()
{
    while read SN CLASS MOD INST DEV EXTRA ; do
	if [ "$SN" != "Socket" ] ; then
	    /etc/pcmcia/$CLASS stop $DEV 2> /dev/null
	fi
    done
}

EXITCODE=1
for x in "1" ; do

    if [ "$PCIC" = "" ] ; then
	echo "PCIC module not defined in startup options!"
	break
    fi

    if [ $# -lt 1 ] ; then usage ; break ; fi
    action=$1

    case "$action" in

    start)
	echo -n "Starting PCMCIA services:"
	if [ -d /var/lib/pcmcia ] ; then
	    SC=/var/lib/pcmcia/scheme
	    RUN=/var/lib/pcmcia
	else
	    SC=/var/run/pcmcia-scheme
	    RUN=/var/run
	fi
	if [ -L $SC -o ! -O $SC ] ; then rm -f $SC ; fi
	if [ ! -f $SC ] ; then umask 022 ; touch $SC ; fi
	if [ "$SCHEME" ] ; then umask 022 ; echo $SCHEME > $SC ; fi
	grep -q pcmcia /proc/devices
	if [ $? -ne 0 ] ; then
	    if [ -d /lib/modules/preferred ] ; then
		PC=/lib/modules/preferred/pcmcia
	    else
		PC=/lib/modules/`uname -r`/pcmcia
	    fi
	    KD=/lib/modules/`uname -r`/kernel/drivers/pcmcia
	    if [ -d $PC ] ; then
		echo -n " modules"
		/sbin/insmod $PC/pcmcia_core.o $CORE_OPTS
		/sbin/insmod $PC/$PCIC.o $PCIC_OPTS
		/sbin/insmod $PC/ds.o
	    elif [ -d $KD ] ; then
		/sbin/modprobe pcmcia_core
		/sbin/modprobe $PCIC
		/sbin/modprobe ds
	    else
		echo " module directory $PC not found."
		break
	    fi
	fi
	if [ -s /var/run/cardmgr.pid ] && \
	    kill -0 `cat /var/run/cardmgr.pid` 2>/dev/null ; then
	    echo " cardmgr is already running."
	else
	    if [ -r $RUN/stab ] ; then
		cat $RUN/stab | cleanup
	    fi
	    echo " cardmgr."
	    /sbin/cardmgr $CARDMGR_OPTS
	fi
	touch /var/lock/subsys/pcmcia 2>/dev/null
	;;

    stop)
	echo -n "Shutting down PCMCIA services:"
	if [ -s /var/run/cardmgr.pid ] ; then
	    PID=`cat /var/run/cardmgr.pid`
	    kill $PID
	    echo -n " cardmgr"
	    # Give cardmgr a few seconds to handle the signal
	    kill -0 $PID 2>/dev/null && sleep 2 && \
	    kill -0 $PID 2>/dev/null && sleep 2 && \
	    kill -0 $PID 2>/dev/null && sleep 2 && \
	    kill -0 $PID 2>/dev/null
	fi
	killall -q "CardBus Watcher"
	if grep -q "ds  " /proc/modules ; then
	    echo -n " modules"
	    /sbin/rmmod ds
	    /sbin/rmmod $PCIC
	    /sbin/rmmod pcmcia_core
	fi
	echo "."
	rm -f /var/lock/subsys/pcmcia
	EXITCODE=0
	;;

    status)
	pid=`/sbin/pidof cardmgr`
	if [ "$pid" != "" ] ; then
	    echo "cardmgr (pid $pid) is running..."
	    EXITCODE=0
	else
	    echo "cardmgr is stopped"
	    EXITCODE=3
	fi
	;;

    restart|reload)
	$0 stop
	$0 start
	EXITCODE=$?
	;;

    *)
	usage
	;;

    esac

done

# Only exit if we're in our own subshell
case $0 in *rc.pcmcia) exit $EXITCODE ;; esac
