-- vlut.vhdl -- variable lookup table
-- Copyright (C) 2000 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: vlut.vhdl,v 1.1 2000/11/19 03:05:29 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity VLUT is
	generic (
		INPUTS : natural := 4
	);
	port (
		A : in std_ulogic_vector(INPUTS-1 downto 0);
		T : in std_ulogic_vector(2**INPUTS-1 downto 0);
		Y : out std_ulogic
	);
end VLUT;

architecture Behave_1 of VLUT is
begin
	process (A, T)
		variable i : integer := 0;
	begin
		lp : for j in A'range loop
			case to_X01(A(j)) is
				when 'X' => i := -1; exit lp;
				when '1' => i := i + 2**j;
				when '0' => null;
			end case;
		end loop lp;
		Y <= 'X';
		if i >= 0 then
			Y <= T(i);
		end if;
	end process;
end Behave_1;
