-- preg.vhdl -- Pipeline Register
-- Copyright (C) 2000 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: preg.vhdl,v 1.1 2000/12/11 05:19:52 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity PipeReg is
	generic (
		WIDTH : natural := 64;
		DOREG : boolean := false
	);
	port (
		Clk, Rst : in std_ulogic;
		D : in std_ulogic_vector(WIDTH-1 downto 0);
		Q : out std_ulogic_vector(WIDTH-1 downto 0)
	);
end PipeReg;

architecture Behave_1 of PipeReg is
begin
	dont_pipe : if not DOREG generate
		Q <= D;
	end generate;
	do_pipe : if DOREG generate
		process (Clk, Rst)
		begin
			if to_X01(Rst) = '1' then
				Q <= (others => '0');
			elsif rising_edge(Clk) then
				Q <= D;
			end if;
		end process;
	end generate;
end Behave_1;
