-- mux2.vhdl -- 2-input MUX
-- Copyright (C) 2000 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: mux2.vhdl,v 1.5 2000/11/04 13:43:45 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity MUX2 is
	port (
		A0, A1, Sel : in std_ulogic;
		Y : out std_ulogic
	);
end MUX2;

architecture Behave_1 of MUX2 is
begin
	Y <= A1 when to_X01(Sel) = '1' else A0 when to_X01(Sel) = '0' else 'X';
end Behave_1;
