-- maj24.vhdl -- 2-of-4 majority gate
-- Copyright (C) 2000 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: maj24.vhdl,v 1.1 2000/10/31 04:57:39 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity MAJ24 is
	port (
		A, B, C, D : in std_ulogic;
		Y : out std_ulogic
	);
end MAJ24;

architecture Struct_1 of MAJ24 is
	component AND2 is
		port (A, B : in std_ulogic; Y : out std_ulogic);
	end component;

	component OR2 is
		port (A, B : in std_ulogic; Y : out std_ulogic);
	end component;

	component OR3 is
		port (A, B, C : in std_ulogic; Y : out std_ulogic);
	end component;

	signal t1, t2, t3, t4, t5, t6, t7, t8 : std_ulogic;
begin
	temp_1 : AND2 port map (A => A, B => B, Y => t1);
	temp_2 : AND2 port map (A => A, B => C, Y => t2);
	temp_3 : AND2 port map (A => A, B => D, Y => t3);
	temp_4 : AND2 port map (A => B, B => C, Y => t4);
	temp_5 : AND2 port map (A => B, B => D, Y => t5);
	temp_6 : AND2 port map (A => C, B => D, Y => t6);
	temp_7 : OR3 port map (A => t1, B => t2, C => t3, Y => t7);
	temp_8 : OR3 port map (A => t4, B => t5, C => t6, Y => t8);
	maj_24 : OR2 port map (A => t7, B => t8, Y => Y);
end Struct_1;
