-------------------------------------------------------------------------
-- f-cpu/vhdl/scheduler/decoding_table.vhdl
-- The instruction decoder's LUT for the FC0
-- Copyright (C) 2001 Yann GUIDON (whygee@f-cpu.org)
-- created dim dec 16 21:24:52 GMT 2001 by whygee@f-cpu.org
-- version mar dec 18 02:38:27 GMT 2001 by whygee@f-cpu.org
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- This is a "behavioural" table that will allow flexible
-- design space exploration while the opcode table is not
-- determined.
--
--
-- note : this is a PURELY combinatorial part, with some hardwired
-- stuff and some other more "dynamic" decoding.
  


LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
LIBRARY work;
    USE work.FCPU_config.ALL;
    USE work.scheduler_definitions.ALL;

Entity decoding_table is
  port(
    F_IN : in Std_ulogic_vector(31 downto 0);  -- the instruction that comes from the fetcher
    --
    interface : out t_dec_interface
  );
end decoding_table;


Architecture simple of decoding_table is
  -- alias the instruction fields :

begin
  
end;
