#! /bin/bash

# f-cpu/vhdl/common/vanilla.sh
# test script for the files (entities and packages) located
# in the f-cpu/vhdl/common/ directory.
# created dim dec 30 08:04:55 GMT 2001 by whygee@f-cpu.org
# (this is just the same as simili.sh except that the tool
#  names are replaced...)

mkvlib work

# 1) test Michael's packages :
va87 -x bit_manipulation.vhdl generic_adder.vhdl &&\
echo MR : ok.
echo ------------------------------------------------

# 2) verify the fanout tree :
va87 -x fanout.vhdl test_fanout.vhdl &&\
echo run | vs87 work.test_fanout &&\
echo fanout : ok.
echo ------------------------------------------------
# note : Vanilla doesn't like fanout_linear.vhdl.

# 3) verify if the tool can do binary read/writes :
rm -f vanilla_binary_ok.touch in out
va87 -x cat.vhdl &&\
dd if=/dev/urandom of=in bs=1k count=10 &&\
echo run | vs87 work.cat &&\
diff in out &&\
touch vanilla_binary_ok.touch &&\
echo binary : ok.
rm -f in
rm -f out
echo ------------------------------------------------

# 4) tests the random package
# va87 -x random.vhdl random_clear.vhdl test_rand.vhdl &&\
#echo run | vs87 work.test_rand &&\
#echo random : ok.
#echo ------------------------------------------------
# Vanilla doesn't like this test, so i discard it.
