-----------------------------------------------------------------------
-- f-cpu/vhdl/scheduler/test_scheduler_queue.vhdl
-- testbench for FC0's scheduling queue
-- Copyright (C) 2001 Yann GUIDON (whygee@f-cpu.org)
-- created lun dec 17 21:03:25 GMT 2001 by whygee@f-cpu.org
-- version jeu dec 20 15:55:03 GMT 2001 adapted from scheduler_slot.vhdl
-- version sam dec 22 07:15:51 GMT 2001 adapted from scheduler_queue.vhdl
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- First revision : let's see if it works :-)
--
-----------------------------------------------------------------------


LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
    use IEEE.std_logic_textio.all;
    use std.textio.all;
LIBRARY work;
    USE work.scheduler_definitions.ALL;
    USE work.scheduler_queue;

entity test_scheduler_queue is
  -- empty
end test_scheduler_queue;

architecture first_try of test_scheduler_queue is

component scheduler_queue is
  port (
    -- in
    clk, reset : in Std_ulogic;
    -- from the instruction word
    R1, R2, R3 : in t_reg;
    -- from the issue logic :
    EU_port1, EU_port2 : st_EU_port;
    issue_level1, issue_level2 : in Std_ulogic_vector(SQ_depth-1 downto 0);
    issue_source1, issue_source2 : in st_mux_port;
    write_mask : st_write_type;
    -- out
    -- goes to the Xbar command lines
    data_out : out t_SQ_slot;
    -- goes to the issue logic
    slot1_busy, slot2_busy : out Std_ulogic_vector(SQ_depth-1 downto 0);
    R1_busy, R2_busy, R3_busy, R4_busy : out Std_ulogic);
  end component;

  signal clk, reset : Std_ulogic;
  signal R1, R2, R3 : t_reg;
  signal EU_port1, EU_port2 : st_EU_port;
  signal issue_level1, issue_level2 :  Std_ulogic_vector(SQ_depth-1 downto 0);
  signal issue_source1, issue_source2 :  st_mux_port;
  signal write_mask : st_write_type;
    -- out
  signal data_out : t_SQ_slot;
  signal slot1_busy, slot2_busy :  Std_ulogic_vector(SQ_depth-1 downto 0);
  signal R1_busy, R2_busy, R3_busy, R4_busy :  Std_ulogic;

begin  -- first_try

  
  dut: component scheduler_queue
    port map (
      clk           => clk,
      reset         => reset,
      R1            => R1,
      R2            => R2,
      R3            => R3,
      EU_port1      => EU_port1,
      EU_port2      => EU_port2,
      issue_level1  => issue_level1,
      issue_level2  => issue_level2,
      issue_source1 => issue_source1,
      issue_source2 => issue_source2,
      write_mask    => write_mask,
      data_out      => data_out,
      slot1_busy    => slot1_busy,
      slot2_busy    => slot2_busy,
      R1_busy       => R1_busy,
      R2_busy       => R2_busy,
      R3_busy       => R3_busy,
      R4_busy       => R4_busy);

  process
    variable lout : line;      

    procedure dpy_queue is
    begin  -- dpy_queue
      wait for 1 ns;
      clk <= '1';
      wait for 1 ns;
      write(lout, string'(" * slot1 : "));
      write(lout, slot1_busy);
      write(lout, string'("  slot2 : "));
      write(lout, slot2_busy);
      write(lout, string'("               busy R1:"));
      write(lout, R1_busy);
      write(lout, string'(" R2:"));
      write(lout, R2_busy);
      write(lout, string'(" R3:"));
      write(lout, R3_busy);
      write(lout, string'(" R4:"));
      write(lout, R4_busy);
      writeline(output, lout);
      write(lout, string'(" data_out :  V1 : "));
      write(lout, data_out.V1);
      write(lout, string'(" R1 : "));
      write(lout, data_out.R1);
      write(lout, string'(" EU1 : "));
      write(lout, data_out.EU1);
      write(lout, string'(" WM1 : "));
      write(lout, data_out.WM1);
      write(lout, string'(" V2 : "));
      write(lout, data_out.V2);
      write(lout, string'(" R2 : "));
      write(lout, data_out.R2);
      write(lout, string'(" EU2 : "));
      write(lout, data_out.EU2);
      write(lout, string'(" WM2 : "));
      write(lout, data_out.WM2);
      writeline(output, lout);
      wait for 1 ns;
      clk <= '0';
      wait for 1 ns;
    end dpy_queue;

  begin  -- process
      -- init/reset :
      R1 <= (others => '0');
      R2 <= (others => '0');
      R3 <= (others => '0');
      clk <= '0';
      reset <= '1';
      issue_level1 <= (others => '0');
      issue_level2 <= (others => '0');

      EU_port1 <= (others => '0');
      EU_port2 <= (others => '0');
      issue_source1 <= (others => '0');
      issue_source2 <= (others => '0');
      write_mask <= (others => '0');

      dpy_queue;

      wait for 1 ns;
      reset <= '0';
      dpy_queue;

      assert (slot1_busy = "00000000") and (slot2_busy = "00000000")
        report "queue should be empty !"
        severity FAILURE;
      assert R1_busy='0' and R2_busy='0' and R3_busy='0' and R4_busy='0'
        report "no register should be busy !"
        severity FAILURE;

      -- now flush the rest of the pipeline :
      for i in 0 to SQ_depth-3 loop
        dpy_queue;
      end loop;

      write(lout, string'(" ----- RESET DONE ----- "));
      writeline(output, lout);


      -- insert R3=5 at slot 4
      -- 1) probe the register availability :
      R1 <= "000001";
      R2 <= "000010";
      R3 <= "000101";
      dpy_queue;

      assert (R1_busy='0') and (R2_busy='0') and (R3_busy='0') and (R4_busy='0')
        report "All the registers should be available !"
        severity FAILURE;

      issue_level1 <= (4 => '1', others => '0');
      EU_port1 <= EU_port_ROP2;
      write_mask <= SQ_write_u64;
      issue_source1 <= MUX_R3;

      dpy_queue;
      issue_level1 <= (others => '0');

      dpy_queue;
      dpy_queue;
      dpy_queue;
      dpy_queue;
      dpy_queue;

      wait;
    end process;

end first_try;
