-----------------------------------------------------------------------
-- f-cpu/vhdl/scheduler/test_scheduler_slot.vhdl
-- Instanciate and test one SQ slot
-- Copyright (C) 2001 Yann GUIDON (whygee@f-cpu.org)
-- created lun dec 17 23:46:57 GMT 2001 by whygee@f-cpu.org
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- First revision : it works :-)
--
-----------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
-- text I/O
    use IEEE.std_logic_textio.all;
    use std.textio.all;
LIBRARY work;
    USE work.scheduler_definitions.ALL;
    USE work.scheduler_slot;

entity test_scheduler_slot is
  -- empty
end test_scheduler_slot;

architecture test of test_scheduler_slot is

  -- copy-paste from the interface :
  signal clk, reset, R1_busy, R2_busy,
    R3_busy, R4_busy  : Std_ulogic;
  signal data_in, data_out : t_SQ_slot;
  signal R1, R2, R3       : Std_ulogic_vector(5 downto 0);

  -- declares the component :
  component scheduler_slot is
  port (
    clk, reset       : in  Std_ulogic;
    data_in          : in  t_SQ_slot;
    R1, R2, R3       : in  Std_ulogic_vector(5 downto 0);
    --
    data_out         : out t_SQ_slot;
    R1_busy, R2_busy,
    R3_busy, R4_busy : out Std_ulogic);
  end component;


begin  -- test

  cut : component scheduler_slot
    port map (
      clk => clk,
      reset => reset,
      data_in => data_in,
      R1 => R1,
      R2 => R2,
      R3 => R3,
      data_out => data_out,
      R1_busy => R1_busy,
      R2_busy => R2_busy,
      R3_busy => R3_busy,
      R4_busy => R4_busy
    );

  -- the verification procedure :
  process
    variable lout : line;

    procedure delay is
    begin  -- delay
      wait for 1 ns;
      write(lout, string'(" R1="));
      write(lout, data_out.R1);
      write(lout, string'(" V1="));
      write(lout, data_out.V1);
      write(lout, string'(" EU1="));
      write(lout, data_out.EU1);
      write(lout, string'(" R2="));
      write(lout, data_out.R2);
      write(lout, string'(" V2="));
      write(lout, data_out.V2);
      write(lout, string'(" EU2="));
      write(lout, data_out.EU2);
      -- comparison outputs :
      write(lout, string'(" busy1="));
      write(lout, R1_busy);
      write(lout, string'(" busy2="));
      write(lout, R2_busy);
      write(lout, string'(" busy3="));
      write(lout, R3_busy);
      write(lout, string'(" busy4="));
      write(lout, R4_busy);
      writeline(output,lout);
      clk <= '1';
      wait for 1 ns;
      clk <= '0';
      wait for 1 ns;
    end delay;

  begin
    -- init all inputs :
    clk <= '0';
    reset <= '0';
    data_in <= (v1|v2=>'1', r1|r2=>(others=>'0'),eu1|eu2=>(others=>'0'));
    R1 <= (others=>'0');
    R2 <= (0 => '1', others=>'0');
    R3 <= (1 => '1', others=>'0');

    delay;
    
    reset <= '1';

    delay;

    delay;

    -- missing : a lot of ASSERTs ! but it worked during the first manual runs.
    
    wait;  
  end process;

end test;
