#!/bin/bash
#  YG's script for compiling the F-CPU VHDL core
# with the command-line Vanilla VHDL.
# created Fri Sep  7 04:22:28 2001 by whygee@f-cpu.org
# version Sat Sep 15 05:48:47 2001

# check if the detection is already performed :
if [ -f tools.env ]
then
    . tools.env
else
    . tool_configure.sh
fi

# check the result
if [ "$VANILLA_STATIC" == "" ]
then
    echo " # could not run Vanilla : aborting."
    exit 1
fi

# one-fits-all function
function vanilla ()
{
    echo ' - making '$1''
    if [ $VANILLA_STATIC = "on" ]
    then 
	if va87 -x $1 | grep ERROR
        then
	     echo 'OOOPS ! something went wrong...'
	     exit 1
        fi
    else
	if echo analyze -x $1 | vv87 | grep ERROR
        then
	    echo 'OOOPS ! something went wrong...'
	    exit 1
	fi
    fi
}


#The following strings are formed with the rule : directory_name=(file1 file2 file_n)
   configuration=(f-cpu_config.vhdl f-cpu_opcodes.vhdl clock_config.vhdl)
          common=(generic_adder.vhdl random.vhdl)
	   clock=(clock_vanilla.vhdl)
         eu_rop2=(rop2_xbar.vhdl rop2_unit.vhdl)
 	  eu_asu=(iadd.vhdl asu.vhdl)
        toplevel=(toplevel.vhdl)

# list of the directory names
     directories=(configuration common clock eu_rop2)

#compile everything :
for j in ${directories[@]}    # scan all the directory names
do
    k=$j[@] # <=there's a trick here
    for l in ${!k} # <= indirection !  scan all the file names
    do
        file="$j/$l" # concatenation
	vanilla $file
    done
done
