#!/bin/bash
#
# YG's script for configuring the VHDL compilers/simulators environment.
# created Sat Sep 15 05:10:45 from various personal files
#
# Please avoid using 'exit' in this script.
#


########################################################################################
# file cleanup
########################################################################################

# reset the configuration script
echo '#!/bin/bash' > tools.env
echo '# Warning ! this file is automatically generated by tool_configure.sh !' >> tools.env

if [ -d work ]
then
    echo '    # removing work/'
    rm -R work
fi

if [ -d work.sym ]
then
    echo '    # removing work.sym/'
    rm -R work.sym
fi

if [ -e random ]
then
    if [ ! -h random ]
    then
	echo '    # notice : the file named random is not a symlink !'
    fi
else
    echo '    # creating a symlink to the random special file'
    ln -s /dev/urandom random
fi


########################################################################################
# (quickly) detect if simili/wine works :
########################################################################################
if wine -debugmsg -all "vhdlp" | grep "Symphony EDA (R) VHDL Compiler/Simulator" > /dev/null
then
    echo "    # simili/wine detected"
    export SIMILI_WINE=ok
    echo 'export SIMILI_WINE=ok' >> tools.env
else
    echo "    # simili doesn't seem to work."
    if [ -n $SIMILI_WINE ]
    then
        unset SIMILI_WINE
    fi
fi


########################################################################################
# detect if vanilla HDL works (using all possible means) :
########################################################################################

# detect vanilla through locate :
if [ -z $(locate mkvlib) ]
then
    echo '    # Vanilla VHDL is not detected through locate. Aborting.'
    if [ -n $VANILLA_STATIC ]
    then
        unset VANILLA_STATIC
    fi

else
    echo "    # Vanilla VHDL's mkvlib is detected in" $(locate mkvlib)

    # check if it works :
    mkvlib 2> outmessage

    if grep "Usage: mkvlib directory_name" outmessage > /dev/null
    then
	rm outmessage
	echo '    # the dynamically linked version works !'
	export VANILLA_STATIC=on
	echo 'export VANILLA_STATIC=on' >> tools.env
	mkvlib work
    else
	if grep "can't load library" outmessage > /dev/null
	then
	    rm outmessage
	    echo '    # the dynamically linked version failed ! i will try with the static version.'
	    if echo | vv87 | grep 'v>' > /dev/null
	    then
		export VANILLA_STATIC=off
		echo 'export VANILLA_STATIC=off' >> tools.env
		echo '    # i found the signature for the static version of Vanilla. cool !'
		echo '    - making working directory -'
		echo 'mkvlib work' | vv87 | grep ERROR
	    else
		echo ' ***** vv87 does not seem to work. Too bad, so close to success...'
		if [ -n $VANILLA_STATIC ]
		then
		    unset VANILLA_STATIC
		fi
	    fi
	else
	    rm outmessage
	    echo '    # mkvlib failed. adios !'
	    if [ -n $VANILLA_STATIC ]
	    then
	        unset VANILLA_STATIC
	    fi
	fi
    fi
fi



########################################################################################
# check the other tools here
########################################################################################

