--------------------------------------------------------------------------
-- f-cpu/vhdl/eu_rop2/test_fanout.vhdl - Testbench for the fanout tree
-- Copyright (C) 2001 Yann GUIDON (whygee@f-cpu.org)
--
-- created lun dec  3 22:43:55 GMT 2001
-- version jeu dec  6 17:05:22 GMT 2001
-- version dim dec 30 07:08:31 GMT 2001 : simplified the component declaration
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
--  Nothing wonderful but it's necessary anyway.
--
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
-- text I/O
    use IEEE.std_logic_textio.all;
    use std.textio.all;
-- local functions
LIBRARY work;
    USE work.fanout;

Entity test_fanout is
  -- empty
end test_fanout;

Architecture arch1 of test_fanout is
  constant LOGWIDTH : natural := 5;   -- Vanilla sometimes segfaults when LOGWIDTH=6 !
  signal l_root : std_ulogic;
  signal even_vector : std_ulogic_vector((2**LOGWIDTH)-1 downto 0);
  signal odd_vector : std_ulogic_vector((2**(LOGWIDTH+1))-1 downto 0);

begin

-- Components under test :
  tree_even: entity work.fanout
    generic map (
      log2_width => LOGWIDTH)
    port map (
      root => l_root,
      leaf => even_vector);

  tree_odd: entity work.fanout
    generic map (
      log2_width => LOGWIDTH+1)
    port map (
      root => l_root,
      leaf => odd_vector);

-- test vectors :
  testbench : process is
    variable lout : line;

    procedure verify_output (
      value : Std_ulogic) is
    begin  -- verify_output

      l_root <= value;
      wait for 1 ns;

      write(lout, string'(" even_vector : "));
      write(lout,even_vector);
      writeline(output, lout);
      write(lout, string'("  odd_vector : "));
      write(lout,odd_vector);
      writeline(output, lout);

      assert even_vector = ((2**LOGWIDTH)-1 downto 0 => l_root)
        report "Output differs from input !! (even)"
        severity FAILURE;
      assert odd_vector = ((2**(LOGWIDTH+1))-1 downto 0 => l_root)
        report "Output differs from input !! (odd)"
        severity FAILURE;

      wait for 1 ns;

    end verify_output;

  begin    -- process
    verify_output('0');
    verify_output('1');
    wait;  -- stop the simulation counter.
  end process;

end;   -- arch1
