#! /bin/bash

# f-cpu/vhdl/common/simili.sh
# test script for the files (entities and packages) located
# in the f-cpu/vhdl/common/ directory.
# created dim dec 30 08:04:55 GMT 2001 by whygee@f-cpu.org

# 1) test Michael's packages :
vhdlp bit_manipulation.vhdl generic_adder.vhdl &&\
echo MR : ok.
echo ------------------------------------------------

# 2) verify the fanout tree :
vhdlp fanout.vhdl test_fanout.vhdl &&\
vhdle test_fanout &&\
vhdlp fanout_linear.vhdl test_fanout.vhdl &&\
vhdle test_fanout &&\
echo fanout : ok.
echo ------------------------------------------------

# 3) verify if the tool can do binary read/writes :
rm -f simili_binary_ok.touch in out
vhdlp cat.vhdl &&\
dd if=/dev/urandom of=in bs=1k count=10 &&\
vhdle cat &&\
diff in out &&\
touch simili_binary_ok.touch &&\
echo binary : ok.
rm -f in
rm -f out
echo ------------------------------------------------

# 4) tests the random package
vhdlp random.vhdl random_file.vhdl test_rand.vhdl &&\
vhdle test_rand &&\
echo random : ok.
echo ------------------------------------------------
# warning : this is incomplete, it only test that the
# package compiles and runs, but doesn't check the output.
