--------------------------------------------------------------------------
-- f-cpu/vhdl/common/fanout.vhdl - Generic fanout tree (2**n) for the F-CPU
-- Copyright (C) 2001 Yann GUIDON (whygee@f-cpu.org)
--
-- created sam dec  1 00:39:05 GMT 2001 by YG for the ROP2 unit, but will
--  certainly be used in a slew other cases.
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- This component implements a balanced fanout tree, for use when a signal
-- must be sent to more than 2**n inputs, where n > 2.
--
-- The version provided in this file is for "quick and dirty coding",
-- or as a failsafe, default alternative. It is also suited for behavioural
-- simulations where it is not necessary to know every net.
-- Depending on the software, this will be more or less efficient. Try each
-- implementation to be sure.
-- 
-- More alternative versions can be added if these ones don't fit your needs.
-- For example, a recursive binary tree could be designed. Other radixes
-- like 3- or 4- are also possible. In this case, compile this file THEN
-- compile the alternative file, so the default architecture s replaced by
-- the most recent one.
--
--------------------------------------------------------------------------

-- some standard librairies
LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
-- text i/o
    use IEEE.std_logic_textio.all;
    use std.textio.all;

-- component interface :
Entity fanout is
  generic (
    log2_width : natural
  );
  port(
    root : in Std_ulogic;
    leaf : out Std_ulogic_vector((2**log2_width)-1 downto 0)
  );
end fanout;

-- failsafe alternative or for behavioural simulations :
Architecture simple of fanout is
begin
  assert (log2_width > 2) and (log2_width < 10)
    report "wrong size range for the binary tree"
    severity FAILURE;

  assert (leaf'low) = 0
    report "array index should start with 0"
    severity FAILURE;
  
  leaf <= (others => root);
end;
