--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- f-cpu/vhdl/clock/test_clock.vhdl, testbench for FC0's clock generator
-- created Wed Sep  5 09:08:08  2001 by Yann GUIDON <whygee@f-cpu.org>
-- Vanilla doesn't pass, as the clock entity doesn't.
-- version Mon Sep 10 07:14:32 2001 : YG tries to make the PLL work. unsuccessfully.
-- version sam dec 29 08:46:47 2001 : updated version with handier signals.
--    Simili AND vanilla are ok but i drop the PLL idea for now.
-- version dim dec 30 05:41:30 2001 : the clock and the simulations are now "restartable".
-- 
-- No "configuration" selection is done, the last architecture is used by default.
-- We try to test the internal clock generation features. The PLL and the
-- external clock are currently dropped. This test is incomplete as long as i'm
-- not able to figure out how to make handy assumptions for regression tests !

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.std_logic_textio.all;
    USE ieee.numeric_std.all;
LIBRARY std;
    USE std.textio.ALL;
LIBRARY work;
    USE work.clock_config.ALL;

Entity test_clock is
   -- no I/O except for display.
end test_clock;

Architecture arch1 of test_clock is
-- clock's in
 signal reset_in : Std_ulogic := '0';   -- external reset
 signal clock_en : Std_ulogic := '0';   -- external clock enable
-- clock's out
 signal reset_out : Std_ulogic := '0';
 signal clock_out : Std_ulogic;  -- clock output for the FC0
 signal clock_ok : Std_ulogic;   -- it is 1 if the output frequency is OK.
 signal period : time := 200 ns; -- this is a signal and not a constant because
                                 -- Vanilla doesn't like it otherwise :-(
begin

-- map the module :
  clock_instance : entity work.clock
  port map(
    reset_in => reset_in,
    reset_out=> reset_out,
    clock_in => open,
    clock_en => clock_en,
    clock_ok => clock_ok,
    clock_out => clock_out,
    clock_mode => open,
    NCO => open,
    prediv => open,
    premul => open,
    clock_period => period
  );

  process
    variable lout : line ;
    variable i : integer := 0;
  begin
    for i in 0 to 1 loop
      -- start
      reset_in <= '1';
      clock_en <= '1';
      WRITE(lout,string'(" ++ START ++"));
      WRITELINE(OUTPUT, lout);

      -- wait and test loop
      if clock_ok /= '1' then
        wait until clock_ok = '1';
      end if;
      wait for period * 5;  -- should display 10 lines out
      WRITE(lout,string'(" ++ STOP ++"));
      WRITELINE(OUTPUT, lout);

      -- stop
      reset_in <= '0';
      clock_en <= '0';

      wait for 1 us; -- should display nothing
    end loop;  -- i
    wait;  -- stop
  end process;

-----------------------------------------------------------------------------
--  Some "spy" processes
-----------------------------------------------------------------------------
  process (clock_out)
    variable cpt : integer := 0;          -- cycle counter
    variable lout : line ;
  begin
    WRITE(lout,string'("| clock_out="));
    WRITE(lout,clock_out);
    WRITE(lout,string'(" time="));
    WRITE(lout,now);
    WRITELINE(OUTPUT, lout);
  end process;

  process (clock_ok)
    variable cpt : integer := 0;          -- cycle counter
    variable lout : line ;
  begin
    WRITE(lout,string'("+ clock_ok="));
    WRITE(lout,clock_ok);
    WRITE(lout,string'(" time="));
    WRITE(lout,now);
    WRITELINE(OUTPUT, lout);
  end process;

  process (reset_out)
    variable cpt : integer := 0;          -- cycle counter
    variable lout : line ;
  begin
    WRITE(lout,string'("+ reset_out="));
    WRITE(lout,reset_out);
    WRITE(lout,string'(" time="));
    WRITE(lout,now);
    WRITELINE(OUTPUT, lout);
  end process;

end;
