#ifndef FCPU_PORTS_H
#define FCPU_PORTS_H

/* f-cpu/include/f-cpu_ports.h
   included by f-cpu/include/f-cpu_config.h

created Sun Aug 12 20:05:20 2001 by whygee@f-cpu.org

 ------------------------BEGIN-LICENCE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENCE-----------------------------------

This file defines the names of the Xbar ports and
the values that are used to switch a specific data.
These values are used by Xbar_write_to_(x) and
Xbar_read_from_(x).

This file is not (yet) generated by m4 scripts
because the VHDL code lags behind the C code.
The same defined values and names will be used,
however, in the future codes.

 */


/* Xbar_read_from_(x)  (Xbar Read cycle) : */
#define PORT_READ_FROM_REGISTER       0   /* the normal stuff */
#define PORT_READ_FROM_BYPASS_0       1   /* bypass write bus 0 */
#define PORT_READ_FROM_BYPASS_0_BIS   2   /* 1-cycle delay of the above (due to R7 latency) */
#define PORT_READ_FROM_BYPASS_1       3   /* bypass write bus 1 */
#define PORT_FROM_FROM_BYPASS_1_BIS   4   /* delay (R7 bypass #2) */
#define PORT_READ_FROM_IMMEDIATE      5   /* from the instruction deocder */
#define PORT_READ_FROM_CIP            6   /* from the fetcher */
#define PORT_READ_FROM_NIP            7   /* from the fetcher */


/* Xbar_write_to_(x)   (Xbar Write cycle) : */
#define PORT_WRITE_FROM_NOTHING       0    /* "nop" */
#define PORT_WRITE_FROM_REGISTER      1    /* register to register write */
#define PORT_WRITE_FROM_IMMEDIATE     2    /* similar to the above but copy from a different port */
#define PORT_WRITE_FROM_ROP2          3    /* ROP2 output */
#define PORT_WRITE_FROM_ASU           4    /* ASU main port */
#define PORT_WRITE_FROM_ASU2          5    /* ASU carry port */
#define PORT_WRITE_FROM_BIST0         6    /* BIST service port 0 */
#define PORT_WRITE_FROM_BIST1         7    /* BIST service port 1 */
/* other EU will be added : IDIV, MUL, INC, LSU,... */

#endif /* EOF */
