--------------------------------------------------------------------------
-- f-cpu/vhdl/eu_rop2/vanilla_testbench.vhdl : ROP2's tesbench for
-- the F-CPU project, Vanilla flavour (stripped down testbench)
-- Copyright (C) 2000 Yann GUIDON (whygee@f-cpu.org) 10/22/2000@20h
-- 
-- Because Vanilla doesn't handle all the VHDL'93 "features", i'm forced to
-- write a "short version" testbench. No external vector file, no parsing, but
-- i don't think it works.
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- Command summary :
-- data buses : ("static")
--  A: set the data_in A bus
--  B: set the data_in B bus
--  C: set the data_in C bus
--  F: set the ROP function (0 to 7)
-- Modes :  (not memorized)
--  O: "combine or" mode
--  D: "combine and" mode
--  M: MUX mode
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.std_logic_textio.all;
    USE ieee.numeric_std.all;
LIBRARY std;
    USE std.textio.ALL;
    USE work.FCPU_config.ALL;

-- the declaration of the design units under test.
    USE work.EU_ROP2;
    USE work.EU_ROP2_XBAR;

entity ROP2_testbench is
  -- no external reference.
end ROP2_testbench;

architecture test of ROP2_testbench is
-- Copy of the design's port declaration :
  signal Din_A, Din_B, Din_C : F_VECTOR;                -- the 3 operands
  signal ROP_function : Std_ulogic_vector(2 downto 0);  -- 3 function bits
  signal ROP2_mode    : Std_ulogic_vector(1 downto 0);  -- operation mode
--signal Combine_size : Std_ulogic_vector(1 downto 0);  -- unused ATM. Byte chuncks only.
  signal Dout         : F_VECTOR;                       -- the result

-- temporary variables between EU_ROP2 and EU_ROP2_XBAR :
  signal
    ROP2_function_bit0,
    ROP2_function_bit1,
    ROP2_function_bit2,
    ROP2_function_bit3 : Std_ulogic_vector((MAXSIZE *2) downto 0);
-- please note : these signal are pipelined in the FC0 but are directly
-- connected in this testbench for simplicity.

-- internal testbench variables :
  shared variable cycle : natural :=0;
  shared variable lout : line ;
  shared variable i : natural;

  procedure print is
  begin
    WRITE(lout,string'("* cycle # : "));
    WRITE(lout,cycle);
-- print all the signals here :
--    WRITE(lout,string'("   ROP2 function:"));
--    HWRITE(lout,ROP_function);
    if (ROP2_mode=ROP2_AND_MODE) then
      WRITE(lout,string'(" MODE : Combine AND"));
    else
      if (ROP2_mode=ROP2_OR_MODE) then
        WRITE(lout,string'(" MODE : Combine OR"));
      else
        if (ROP2_mode=ROP2_MUX_MODE) then
          WRITE(lout,string'(" MODE : MUX"));
        else
          WRITE(lout,string'(" MODE : Normal"));
        end if;
      end if;
    end if;
    WRITELINE(OUTPUT, lout);
    WRITE(lout,string'(" Din_A="));
    HWRITE(lout,Din_A);
    WRITELINE(OUTPUT, lout);
    WRITE(lout,string'(" Din_B="));
    HWRITE(lout,Din_B);
    WRITELINE(OUTPUT, lout);
    WRITE(lout,string'(" Din_C="));
    HWRITE(lout,Din_C);
    WRITELINE(OUTPUT, lout);
    WRITE(lout,string'("  Dout="));
    HWRITE(lout,Dout);
    WRITELINE(OUTPUT, lout);
  end;


begin

 -- Instantiate the tested circuit
 ROP2_instance_1 : entity EU_ROP2_XBAR
   port map(
     ROP2_function => ROP_function,
     ROP2_function_bit0 => ROP2_function_bit0,
     ROP2_function_bit1 => ROP2_function_bit1,
     ROP2_function_bit2 => ROP2_function_bit2,
     ROP2_function_bit3 => ROP2_function_bit3
   );

 ROP2_instance_2 : entity EU_ROP2
   port map(
     ROP2_in_A => Din_A,
     ROP2_in_B => Din_B,
     ROP2_in_C => Din_C,
     ROP2_function_bit0 => ROP2_function_bit0,
     ROP2_function_bit1 => ROP2_function_bit1,
     ROP2_function_bit2 => ROP2_function_bit2,
     ROP2_function_bit3 => ROP2_function_bit3,
     ROP2_mode => ROP2_mode,
     ROP2_out => Dout
   );

 -- the testbench routine :
 process
   variable temp_mode : Std_ulogic_vector(1 downto 0);
 begin
-- simulation body :

     -- init temps :
     temp_mode:=(others =>'0');

     -- read one vector


     -- perform the assignation :
     ROP2_mode<=temp_mode;

     -- cycle :
     cycle:=cycle+1;   -- advance the counter
     wait for 10 ns;   -- let the circuit do the work
     print;            -- be happy

   wait; -- stop the simulation
 end process;

end test;
