--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- f-cpu/vhdl/clock/clock_vanilla.vhdl, clock generator for the FC0
-- created Wed Sep  5 04:35:14 2001 by Yann GUIDON <whygee@f-cpu.org>
-- version Fri Sep  7 09:01:17 
--
-- This file is a short subset from f-cpu/vhdl/clock/clock.vhdl
-- so some tools can bypass the ugly guts of the original file.
-- For example, Vanilla lacks some libraries that Simili has.
-- This file is very feature-poor but it will help for synthesis
-- and simulation for impaired configurations.
--
-- PLEASE REFER TO f-cpu/vhdl/clock/clock.vhdl

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
LIBRARY work;
    USE work.clock_config.ALL;

Entity clock is
  port(
-- external (off-core) inputs :
    reset_in : in Std_ulogic;    -- circuit can operate if 1.
    clock_in : in Std_ulogic;    -- external clock input
    snore : in Std_ulogic;       -- ask the CPU to reduce its clock frequency
      -- Note : it has priority over the internal signals but it only works if the
      -- current mode is PLL. If you want to slow-down in HW, you'll have to divide
      -- the external clock yourself. This part should be better managed in the future.
-- configuration (read from the SR) :
    clock_mode : in clock_mode_type;
    prediv,                      -- division factor for the external clock
    premul : std_ulogic_vector(CLOCK_COUNTER_SIZE-1 downto 0);
       -- division factor for the internal clock
    NCO : std_ulogic_vector(CLOCK_NCO_SIZE-1 downto 0);  -- internal clock frequency

-- outputs :
    clock_ok : out Std_ulogic;   -- it is 1 if the output frequency is OK.
    clock_out : out Std_ulogic  -- clock output for the FC0
-- warning : this is only a preliminary interface. It will be changed later.
  );
end clock;

-------------------------------------------------------------------------------
-- this one can be used to make quick tests.
-- it won't synthesise but it's helpful for debugging.
-------------------------------------------------------------------------------
Architecture dumb of clock is
  signal clk : std_ulogic := '0';
begin
   -- dumb 100MHz clock (with a nice on-off button)
  clk <= (reset_in and not clk) after 5 ns;
  clock_out <= clk;
   -- allow the core to boot
  clock_ok <= reset_in;
end;

-------------------------------------------------------------------------------
-- this one can be used to make "real" tests.
-- it is a very limited version which requires an external clock and nothing is
-- done at all. Use this architecture if you want to synthesize for the first time.
-------------------------------------------------------------------------------
Architecture simple of clock is
begin
   -- copy the output ("mode 1 only")
  clock_out <= clock_in;
   -- allow the core to boot
  clock_ok <= reset_in;
end;
