/*

 f-cpu/ygasm/ygasm.h :

This is a Free Software created ven avr 28 14:51:39 CEST 2000 by Yann GUIDON
Sun Jul 15 18:00:28 2001 : renamed from gnl_node.h to ygasm.h

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <f-cpu_config.h>     /* common F-CPU ressource file */
/* don't forget the "-I../" argument when calling GCC ! */

/*********************************************************
 here we put global variables for the parser and analyser.
 *********************************************************/

unsigned int
/* for the IFDEF stuffs */
 skip_count=0,    /* depth of the skipped #IFDEFs */
 ifdef_count=0,   /* flag for ifdef->endif (nesting count) */
#define MAX_IFDEF (sizeof(int)*8) /* it's implementation dependent ! */
 else_count=0,    /* flag for only one #ELSE  -> ACTUALLY this is a bit stack ! */
 warning_count=0,          /* is it THAT useful ? */
 count_nested_comments=0,  /* nested comments counter */
 enable_nested_comments=1000, /* can be modified within the parser */
 Line_Number=1,            /* the global one */
 parse_line;               /* line_number of the beginning of the instruction */

FILE *out_file;

/* FILE DESCRIPTOR used as a (linked) "include" stack */
struct include_node {
  void * next;          /* linked list, terminated by p->next==p */
  FILE *input_file;     /* backup of the global variable */
  int node_line_number; /* backup */
  char filename[1];     /* first byte of a normal string */
} *include_prec;        /* points to the last valid node, that is: the current file */

/* #DEFINEs and other preprocessor commands */
struct define_node {
  void * next;         /* linked list, finished when p->next==NULL */
  int line;            /* where it is DEFINed */
  struct define_node * last_scan; /* is an include_node when NULL, a *define_node otherwise */
  char *buffer;        /* where the definition is stored; uses realloc */
  int buffer_size;     /* number of char. in the buffer */
  signed int char_counter; /* points to the next char to be read, -1 if not in use */
  char string[1];      /* this byte only contains the size (like with PASCAL strings): */
} *define_prec=NULL, /* tail of the linked list */
  *current_define=NULL;     /* the one that's currently read from */

typedef struct struct_symbol {
  int size; /* strlen */
  u64 value; /* for the labels and other stuffs */
  int attributes; /* will be extended later, for type checking for example */
  int line;  /* where the label is defined (sometimes, declared as global, then overwritten) */
  struct include_node *include_file; /* points to the file desriptor (for the error messages) */
  struct struct_symbol * left, *right;
  char name[0]; /* dirty trick, but it works... */
} symbol;

symbol *referenced_symbol;
