--------------------------------------------------------------------------
-- rop_xbar.vhdl - ROP2 signal conditioning for the F-CPU
-- Copyright (C) 2000-2001 Yann GUIDON (whygee@f-cpu.org)
--
-- v0.2: Michael Riepe reorganized the main for-generate loop
-- + corrected the lookup table (wrong op for ORN)
-- v0.3: YG replaced UMAX/8 with MAXSIZE :-)
-- v0.4: 11/17/2000, YG wants to rewrite the unit with MR's gate library ...
-- v0.5: 8/12/2001, YG modifies the interface, the names, adds MUX,...
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--
--------------------------------------------------------------------------
-- Warning : this code is and should remain purely combinatorial,
-- there is no latching here, it must be done at another level.
-- The function lookup table is moved now earlier
-- in the pipeline, in parallel with the Xbar cycle.
-- The big fanout problems (propagation of the opcode from 1 to 64 bits)
-- overlaps the Xbar cycle so we can make a nice "signal tree".
--------------------------------------------------------------------------
-- version : Tue Aug 21 11:28:52 2001 by whygee@f-cpu.org
-- I just created the new entity, separating its function from the ROP2 EU.

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
LIBRARY work;
    USE work.FCPU_config.ALL;

Entity EU_ROP2_XBAR is
  port(
    ROP2_function : in Std_ulogic_vector(2 downto 0); -- the input, "compressed" function
    ROP2_function_bit0,
    ROP2_function_bit1,   -- pre-buffered boolean function bits
    ROP2_function_bit2,
    ROP2_function_bit3 : out Std_ulogic_vector((MAXSIZE *2) downto 0); -- fanout=4 
    ROP2_mode : in Std_ulogic_vector(1 downto 0);  -- 2 function bits from the instruction
  );
end EU_ROP2_XBAR;

Architecture arch1 of EU_ROP2_XBAR is
  signal local_function : std_ulogic_vector(3 downto 0); -- the partial results.

begin

---- lookup table that decodes the function bits
--   with ROP_function select
--     local_function <=
--       "0001" when "000",  -- AND
--       "0010" when "001",  -- ANDN
--       "0110" when "010",  -- XOR
--       "0111" when "011",  -- OR
--       "1000" when "100",  -- NOR
--       "1001" when "101",  -- XNOR
--       "1011" when "110",  -- ORN
--       "1110" when others; -- NAND

  with ROP_function select
    local_function <=
      ROP2_VALUE_AND  when ROP2_AND,
      ROP2_VALUE_ANDN when ROP2_ANDN,
      ROP2_VALUE_XOR  when ROP2_XOR,
      ROP2_VALUE_OR   when ROP2_OR,
      ROP2_VALUE_NOR  when ROP2_NOR,
      ROP2_VALUE_XNOR when ROP2_XNOR,
      ROP2_VALUE_ORN  when ROP2_ORN,
      ROP2_VALUE_NAND when others;

-- The signal tree :
  ROP2_function_bit0 <= (others => local_function(0));
  ROP2_function_bit1 <= (others => local_function(1));
  ROP2_function_bit2 <= (others => local_function(2));
  ROP2_function_bit3 <= (others => local_function(3));

end;
