#ifndef FCPU_TYPES_H
#define FCPU_TYPES_H

/*
f-cpu/include/f-cpu_types.h
included by f-cpu/f-cpu_config.h

created Sun Aug 12 02:49:49 2001 by whygee@f-cpu.org

 -------------------------------------------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 -------------------------------------------------------------------------

This file contains the declaration of the data types
that are commonly used in the programs that deal with the F-CPU.
This one is not generated by m4 scripts because it is too
langage-dependent. However, please check the size of UMAX/SMAX
because it is not yet automatically updated (there is no 128+ bit
wide data support in most compilers).

 */

/* the F-CPU standard types : */
typedef unsigned char u8;
typedef   signed char s8;
typedef unsigned short int u16;
typedef   signed short int s16;
typedef unsigned long int u32;
typedef   signed long int s32;
typedef unsigned long long int u64;
typedef   signed long long int s64;

typedef u64 UMAX;   /* these types must be updated */
typedef s64 SMAX;   /* if the CPU can handle wider data */

typedef unsigned char bool; /* this one is apparently not defined by GCC */

#endif /* EOF */
