# f-cpu/configure.sh
# created Sun Aug 19 08:11:56 2001 by whygee@f-cpu.org
#
# -------------------------------------------------------------------------
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# -------------------------------------------------------------------------
#
# This file creates the include files and constant VHDL
# packages from the configuration defined in the files
# in f-cpu/configuration/
echo " * configure.sh : little F-CPU source configuration script"
echo " * creating frozen state files"
m4 -F configuration/langage_vhdl.m4f --prefix-builtins configuration/langage_vhdl.m4 configuration/main.m4 > /dev/null
m4 -F configuration/langage_c.m4f    --prefix-builtins configuration/langage_c.m4    configuration/main.m4 > /dev/null
echo " * updating f-cpu/include/ "
m4 -R configuration/langage_c.m4f --prefix-builtins configuration/f-cpu_memory.h.in > include/f-cpu_memory.h
m4 -R configuration/langage_c.m4f --prefix-builtins configuration/f-cpu_opcodes.h.in > include/f-cpu_opcodes.h
m4 -R configuration/langage_c.m4f --prefix-builtins configuration/f-cpu_features.h.in > include/f-cpu_features.h
echo " * updating f-cpu/vhdl/ "
m4 -R configuration/langage_vhdl.m4f --prefix-builtins configuration/f-cpu_config.vhdl.in > vhdl/f-cpu_config.vhdl
m4 -R configuration/langage_vhdl.m4f --prefix-builtins configuration/f-cpu_opcodes.vhdl.in > vhdl/f-cpu_opcodes.vhdl
