--------------------------------------------------------------------------
-- f-cpu/vhdl/registers/test_R7.vhdl - Testbench for the R7
-- Copyright (C) 2002 Etienne LABARRE (etienne.labarre@gadz.org)
-- Tue Mar 12 12:24:39 CET 2002
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
--
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
-- text I/O
    use IEEE.std_logic_textio.all;
    use std.textio.all;
-- local functions
LIBRARY work;
    USE work.FCPU_config.ALL;
    USE work.R7;

Entity test_R7 is
  -- empty
end test_R7;

Architecture arch1 of test_R7 is
  signal in0 : F_VECTOR;
  signal in1 : F_VECTOR;
  signal in2 : F_VECTOR;

  signal ou0 : F_VECTOR;
  signal ou1 : F_VECTOR;

  signal wmask0 : std_ulogic_vector(4 downto 0);
  signal wmask1 : std_ulogic_vector(4 downto 0);
  signal rmask0 : std_ulogic_vector(4 downto 0);
  signal rmask1 : std_ulogic_vector(4 downto 0);
  signal rmask2 : std_ulogic_vector(4 downto 0);

  signal rad0 : std_ulogic_vector(5 downto 0);
  signal rad1 : std_ulogic_vector(5 downto 0);
  signal rad2 : std_ulogic_vector(5 downto 0);

  signal wad0 : std_ulogic_vector(5 downto 0);
  signal wad1 : std_ulogic_vector(5 downto 0);

  signal clock : std_ulogic;

  signal r0 : std_ulogic;
  signal r1 : std_ulogic;
  signal r2 : std_ulogic;

  signal w0 : std_ulogic;
  signal w1 : std_ulogic;

  signal lsb_0 : std_ulogic;
  signal lsb_1 : std_ulogic;
  signal lsb_2 : std_ulogic;
  signal msb_0 : std_ulogic;
  signal msb_1 : std_ulogic;
  signal msb_2 : std_ulogic;
  signal nul_0 : std_ulogic;
  signal nul_1 : std_ulogic;
  signal nul_2 : std_ulogic;

begin

-- Component under test :
   R7_in_test : entity R7
      generic map(
         ROW_NUMBER => 5,
	 REGISTER_LOG => 6
         )
      port map(
         R7_read_port_0 => in0,
         R7_read_port_1 => in1,
         R7_read_port_2 => in2,

	 R7_write_port_0 => ou0,
	 R7_write_port_1 => ou1,

	 R7_read_adress_0 => rad0,
	 R7_read_adress_1 => rad1,
	 R7_read_adress_2 => rad2,

	 R7_write_adress_0 => wad0,
	 R7_write_adress_1 => wad1,

	 R7_control_read_0 => r0,
	 R7_control_read_1 => r1,
	 R7_control_read_2 => r2,

	 R7_control_write_0 => w0,
	 R7_control_write_1 => w1,

	 R7_write_mask_0 => wmask0,
	 R7_write_mask_1 => wmask1,

	 R7_read_mask_0 => rmask0,
	 R7_read_mask_1 => rmask1,
	 R7_read_mask_2 => rmask2,

	 R7_lsb_0  => lsb_0,
	 R7_lsb_1  => lsb_1,
	 R7_lsb_2  => lsb_2,
	 R7_msb_0  => msb_0,
	 R7_msb_1  => msb_1,
	 R7_msb_2  => msb_2,
	 R7_null_0 => nul_0,
	 R7_null_1 => nul_1,
	 R7_null_2 => nul_2,

         R7_clock => clock
	 );

   -- test vectors :
   testbench : process is
      variable lout  : line;
      variable adress_count : std_ulogic_vector(5 downto 0);
  
      -- procedure for increment adress
      procedure inc_add ( 
         inc_ad : inout std_ulogic_vector(5 downto 0) ) is
         variable tmp_ad : std_ulogic_vector(5 downto 0);
	 variable  carry : std_ulogic; 
      begin

         tmp_ad := inc_ad;
         carry  := '1';
            
         -- add 1 to tmp_ad
	 for j in 0 to 5 loop
	    if carry = '1' then
	       if tmp_ad(j) = '0' then
	          tmp_ad(j) := '1';
	          carry     := '0';
	       else
	          tmp_ad(j) := '0';
	          carry     := '1';
	       end if;
	    else
	       if tmp_ad(j) = '0' then
	          tmp_ad(j) := '0';
		  carry     := '0';
	       else
		  tmp_ad(j) := '1';
		  carry     := '0';
	       end if;
	    end if;
	 end loop;

	 inc_ad := tmp_ad;

      end procedure;


      -- procedure for write by port 0
      procedure write_0 (
         adress : std_ulogic_vector(5 downto 0);
	 data   : F_VECTOR ) is

      begin
	 wad0 <= adress;
	 wad1 <= (others => '0');
	 ou0  <= data;
	 w1   <= '1';  

	 wait for 1 ns;
	 w0   <= '0';
	 wait for 1 ns;
	 clock <= '0';
	 wait for 1 ns;
	 clock <= '1';
	 wait for 1 ns;
         w0   <= '1';
	 wait for 1 ns;

      end procedure;

      -- procedure for write by port 1
      procedure write_1 (
         adress : std_ulogic_vector(5 downto 0);
	 data   : F_VECTOR ) is

      begin
	 wad1 <= adress;
	 wad0 <= (others => '0');
	 ou1  <= data;
	 w0   <= '1'; 

	 wait for 1 ns;
	 w1   <= '0';
	 wait for 1 ns;
	 clock <= '0';
	 wait for 1 ns;
	 clock <= '1';
	 wait for 1 ns;
         w1   <= '1';
	 wait for 1 ns;

      end procedure;

      -- procedure for read by port 0
      procedure read_0 (
         adress : std_ulogic_vector(5 downto 0) ) is

      begin
	 rad0 <= adress;

	 wait for 1 ns;
	 r0   <= '0'; 
	 wait for 1 ns;
	 clock <= '0';
	 wait for 1 ns;
	 clock <= '1';
	 wait for 1 ns;
         r0   <= '1';
	 wait for 1 ns;

         write(lout, string'("Read 0 : "));
         write(lout, adress);
         write(lout, string'(" : "));
         write(lout, lsb_0);
         write(lout, string'(" : "));
         write(lout, msb_0);
         write(lout, string'(" : "));
         write(lout, nul_0);
         write(lout, string'(" : "));
         write(lout, in0);
         writeline(output, lout);

      end procedure;
      
      -- procedure for read by port 1
      procedure read_1 (
         adress : std_ulogic_vector(5 downto 0) ) is

      begin
	 rad1 <= adress;

	 wait for 1 ns;
	 r1   <= '0'; 
	 wait for 1 ns;
	 clock <= '0';
	 wait for 1 ns;
	 clock <= '1';
	 wait for 1 ns;
         r1   <= '1';
	 wait for 1 ns;

         write(lout, string'("Read 1 : "));
         write(lout, adress);
         write(lout, string'(" : "));
         write(lout, lsb_1);
         write(lout, string'(" : "));
         write(lout, msb_1);
         write(lout, string'(" : "));
         write(lout, nul_1);
         write(lout, string'(" : "));
         write(lout, in1);
         writeline(output, lout);

      end procedure;

      -- procedure for read by port 2
      procedure read_2 (
         adress : std_ulogic_vector(5 downto 0) ) is

      begin
	 rad2 <= adress;

	 wait for 1 ns;
	 r2   <= '0'; 
	 wait for 1 ns;
	 clock <= '0';
	 wait for 1 ns;
	 clock <= '1';
	 wait for 1 ns;
         r2   <= '1';
	 wait for 1 ns;

         write(lout, string'("Read 2 : "));
         write(lout, adress);
         write(lout, string'(" : "));
         write(lout, lsb_2);
         write(lout, string'(" : "));
         write(lout, msb_2);
         write(lout, string'(" : "));
         write(lout, nul_2);
         write(lout, string'(" : "));
         write(lout, in2);
         writeline(output, lout);

      end procedure;

      -- procedure for read all registers by port 0
      procedure verify_output_0 ( 
         mask : std_ulogic_vector(4 downto 0) ) is
      begin
         write(lout, string'(" * Relecture port 0 **** "));
         writeline(output, lout);

         adress_count := "000000";
	 rmask0 <= mask;

	 for i in 63 downto 0 loop
            read_0(adress_count);
	    inc_add(adress_count);
	 end loop;
      end procedure;
         
      -- procedure for read all registers by port 1
      procedure verify_output_1 ( 
         mask : std_ulogic_vector(4 downto 0) ) is
      begin
         write(lout, string'(" * Relecture port 1 **** "));
         writeline(output, lout);

         adress_count := "000000";
	 rmask1 <= mask;

	 for i in 63 downto 0 loop
            read_1(adress_count);
	    inc_add(adress_count);
	 end loop;
      end procedure;

      -- procedure for read all registers by port 2
      procedure verify_output_2 ( 
         mask : std_ulogic_vector(4 downto 0) ) is
      begin
         write(lout, string'(" * Relecture port 2 **** "));
         writeline(output, lout);

         adress_count := "000000";
	 rmask2 <= mask;

	 for i in 63 downto 0 loop
            read_2(adress_count);
	    inc_add(adress_count);
	 end loop;
      end procedure;

  begin    -- process
    write(lout, string'("  "));
    writeline(output, lout);
    write(lout, string'(" *** start of tests *** "));
    writeline(output, lout);

    -- init signaux de controle
    w0 <= '1';
    w1 <= '1';
    wmask0 <= "00000";
    wmask1 <= "00000";
   
    wait for 1 ns;
    clock <= '0';
    wait for 1 ns;
    clock <= '1';
    wait for 1 ns;

    adress_count := "000000";

    write(lout, string'(" ******** Contenu des tests *******"));
    writeline(output, lout);
    write(lout, string'(" * 1 criture  l'adresse 0 (FF..) "));
    writeline(output, lout);
    write(lout, string'(" ******** Ecriture par port 0 *****"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 8  bits 0-7"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 8  bits 8-15"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 16 bits 0-15"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 16 bits 16-31"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 16 bits 32-47"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 16 bits 48-63"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 32 bits 0-31"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 32 bits 31-63"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 64 bits 0-63"));
    writeline(output, lout);
    write(lout, string'(" ******** Ecriture par port 1 *****"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 8  bits 0-7"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 8  bits 8-15"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 16 bits 0-15"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 16 bits 16-31"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 16 bits 32-47"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 16 bits 48-63"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 32 bits 0-31"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 32 bits 31-63"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  0 en mode 64 bits 0-63"));
    writeline(output, lout);
    write(lout, string'(" ******** Ecriture par port 0 *****"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 8  bits 0-7"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 8  bits 8-15"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 16 bits 0-15"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 16 bits 16-31"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 16 bits 32-47"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 16 bits 48-63"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 32 bits 0-31"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 32 bits 31-63"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 64 bits 0-63"));
    writeline(output, lout);
    write(lout, string'(" ******** Ecriture par port 1 *****"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 8  bits 0-7"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 8  bits 8-15"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 16 bits 0-15"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 16 bits 16-31"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 16 bits 32-47"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 16 bits 48-63"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 32 bits 0-31"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 32 bits 31-63"));
    writeline(output, lout);
    write(lout, string'(" * 1 adresses crites  F en mode 64 bits 0-63"));
    writeline(output, lout);

    wmask0 <= "11111";
    write_0(adress_count,x"0000000000000000");
    inc_add(adress_count);

    wmask0 <= "00001";
    write_0(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask0 <= "00010";
    write_0(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask0 <= "00011";
    write_0(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask0 <= "00100";
    write_0(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask0 <= "01000";
    write_0(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask0 <= "10000";
    write_0(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask0 <= "00111";
    write_0(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask0 <= "11000";
    write_0(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask0 <= "11111";
    write_0(adress_count,x"0000000000000000");
    inc_add(adress_count);

    wmask1 <= "00001";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "00010";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "00011";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "00100";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "01000";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "10000";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "00111";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "11000";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "11111";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);

    wmask0 <= "00001";
    write_0(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask0 <= "00010";
    write_0(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask0 <= "00011";
    write_0(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask0 <= "00100";
    write_0(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask0 <= "01000";
    write_0(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask0 <= "10000";
    write_0(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask0 <= "00111";
    write_0(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask0 <= "11000";
    write_0(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask0 <= "11111";
    write_0(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);

    wmask1 <= "00001";
    write_1(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask1 <= "00010";
    write_1(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask1 <= "00011";
    write_1(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask1 <= "00100";
    write_1(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask1 <= "01000";
    write_1(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask1 <= "10000";
    write_1(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask1 <= "00111";
    write_1(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask1 <= "11000";
    write_1(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask1 <= "11111";
    write_1(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);

    wmask0 <= "11111";
    write_0(adress_count,x"0123456789ABCDEF");
    inc_add(adress_count);
    wmask0 <= "11111";
    write_0(adress_count,x"FEDCBA9876543210");
    inc_add(adress_count);
    wmask0 <= "11111";
    write_0(adress_count,x"AAAAAAAAAAAAAAAA");
    inc_add(adress_count);
    wmask0 <= "11111";
    write_0(adress_count,x"5555555555555555");
    inc_add(adress_count);
    wmask0 <= "11111";
    write_0(adress_count,x"AAAA5555AAAA5555");
    inc_add(adress_count);
    wmask0 <= "11111";
    write_0(adress_count,x"5555AAAA5555AAAA");
    inc_add(adress_count);
    wmask0 <= "11111";
    write_0(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask0 <= "11111";
    write_0(adress_count,x"0001000100010101");
    inc_add(adress_count);
    wmask0 <= "11111";
    write_0(adress_count,x"0010001000101010");
    inc_add(adress_count);

    wmask1 <= "11111";
    write_1(adress_count,x"FFFFFFFFFFFFFFFF");
    inc_add(adress_count);
    wmask1 <= "11111";
    write_1(adress_count,x"FFFEFFFEFFFEFEFE");
    inc_add(adress_count);
    wmask1 <= "11111";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "11111";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "11111";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "11111";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "11111";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "11111";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);
    wmask1 <= "11111";
    write_1(adress_count,x"0000000000000000");
    inc_add(adress_count);

    write(lout, string'(" * Resultats :"));
    writeline(output, lout);
    verify_output_0("00001");
    verify_output_0("00010");
    verify_output_0("00011");
    verify_output_0("00100");
    verify_output_0("01000");
    verify_output_0("10000");
    verify_output_0("00111");
    verify_output_0("11000");
    verify_output_0("11111");

    wait;
  end process;

end;
