-------------------------------------------------------------------------------
-- sram2r3w_simple.vhdl : a basic behavioural multiport SRAM bloc for building
-- the F-CPU register set, created sat. feb. 9 04:40:36 GMT 2002 by whygee@f-cpu.org
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
--  This is a first prototype for this "generic" SRAM block.
-- another implementation should ideally provided, implementing a SW-generated
-- custom block whenever possible.
--
-------------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
    use IEEE.std_logic_textio.all;
    use std.textio.all;
LIBRARY work;
    USE work.sram3r2w;

entity test_sram3r2w is
  -- empty
end test_sram3r2w;

architecture testbench of test_sram3r2w is
  constant test_width : integer := 16;  -- data width in the testbench
  signal AdrRead1, AdrRead2, AdrRead3, AdrWrite1, AdrWrite2 : std_ulogic_vector(5 downto 0);
  signal DataWrite1, DataWrite2 : std_ulogic_vector(test_width-1 downto 0);
  signal WriteEn1, WriteEn2 : std_ulogic := '0';
  signal DataRead1, DataRead2, DataRead3 : std_ulogic_vector(test_width-1 downto 0);

begin  -- testbench

  sram : entity sram3r2w
    generic map (width => 16)
    port map (
      AdrRead1 => AdrRead1,
      AdrRead2 => AdrRead2,
      AdrRead3 => AdrRead3,
      AdrWrite1 => AdrWrite1,
      AdrWrite2 => AdrWrite2,
      WriteEn1 => WriteEn1,
      WriteEn2 => WriteEn2,
      DataWrite1 => DataWrite1,
      DataWrite2 => DataWrite2,
      DataRead1 => DataRead1,
      DataRead2 => DataRead2,
      DataRead3 => DataRead3
    );

test_driver : process
  variable lout : line;
  begin
    AdrWrite1 <= "000000";
    AdrWrite2 <= "000000";
    AdrRead1 <= "000000";
    AdrRead2 <= "000000";
    AdrRead3 <= "000000";
    WriteEn1 <= '0';
    WriteEn2 <= '0';

--     wait for 1 ns;

--     write(lout, DataRead1);
--     writeline(output, lout);
--     write(lout, DataRead2);
--     writeline(output, lout);
--     write(lout, DataRead3);
--     writeline(output, lout);
    wait for 1 ns;
    
    -- one write cycle :

    AdrWrite1 <= "000100";
    DataWrite1 <= "0110101101000001";
    WriteEn1 <= '1';
    wait for 1 ns;
    WriteEn1 <= '0';
    wait for 1 ns;

    -- one read cycle :

    AdrRead1 <= "000100";
    wait for 1 ns;
    AdrRead1 <= "000000";

    wait; -- the end.
  end process;

  process (DataRead1)
    variable lout : line;
  begin
    write(lout, now);
    write(lout, string'(" DataRead1 = "));
    write(lout, DataRead1);
    writeline(output, lout);
  end process;

  process (DataRead2)
    variable lout : line;
  begin
    write(lout, now);
    write(lout, string'(" DataRead2 = "));
    write(lout, DataRead2);
    writeline(output, lout);
  end process;

  process (DataRead3)
    variable lout : line;
  begin
    write(lout, now);
    write(lout, string'(" DataRead3 = "));
    write(lout, DataRead3);
    writeline(output, lout);
  end process;

end testbench;
