-------------------------------------------------------------------------------
-- sram2r3w_simple.vhdl : a basic behavioural multiport SRAM bloc for building
-- the F-CPU register set, created sat. feb. 9 04:40:36 GMT 2002 by whygee@f-cpu.org
--
-- version feb 10 00:00:10 GMT 2002 : almost everything is a process and
-- the index problems (when zero, undetermined etc.) are solved.
-- A lot of debugging code is left, but commented out, in case it is useful later.
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
--  This is a first prototype for this "generic" SRAM block.
-- another implementation should ideally provided, implementing a SW-generated
-- custom block whenever possible.

-- missing : clk

--
-------------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
--     --
--     use IEEE.std_logic_textio.all;
--     use std.textio.all;
--     --
LIBRARY work;
    USE work.sram3r2w;


architecture prototype of sram3r2w is

  subtype RAM_word is std_ulogic_vector(width-1 downto 0);  -- definition of one element
  type RAM_ARRAY_TYPE is array(63 downto 1) of RAM_word;
  signal RAM_ARRAY : RAM_ARRAY_TYPE;    -- the array itself

  -- dirty hack :-(
  function sulv_to_int (sulv : std_ulogic_vector)
    return integer is
    variable i,j : integer := 0;
  begin  -- sulv_to_int

    assert sulv'low = 0
      report "lower index must be zero !"
      severity FAILURE;

    for i in sulv'high downto sulv'low loop
      j := j*2;
      if sulv(i) = '1' then
        j := j+1;
      else
        if sulv(i) /= '0' then
          return 0;   -- safety net because
          -- when the component is not connected, the addresses are "floating"
          -- and trigger index errors so here we select one address by default.

-- important note : since Us and Xs etc. don't appear in real life, this function
-- does not represent the _real_ behaviour of the bank. Usually, when decoding
-- a "000000", the decoder does nothing (the corresponding address is not wired)

        end if;
      end if;
    end loop;  -- i
    return j;
  end sulv_to_int;
  
begin  -- prototype 

-------------------------------------------------------------------------------
-- asynchronous reads :
-------------------------------------------------------------------------------

  process (AdrRead1)
    variable index : integer;
--     variable lout : line;
  begin
    index := sulv_to_int(AdrRead1);
    if (index = 0) then
      DataRead1 <= (others => '0');
    else
      DataRead1 <= RAM_ARRAY(index);
    end if;
--     write(lout, now);
--     write(lout, string'(" lecture du port 1  l'index "));
--     write(lout, index);
--     writeline(output, lout);
  end process;

  process (AdrRead2)
    variable index : integer;
  begin
    index := sulv_to_int(AdrRead2);
    if (index = 0) then
      DataRead2 <= (others => '0');
    else
      DataRead2 <= RAM_ARRAY(index);
    end if;
  end process;

  process (AdrRead3)
    variable index : integer;
  begin
    index := sulv_to_int(AdrRead3);
    if (index = 0) then
      DataRead3 <= (others => '0');
    else
      DataRead3 <= RAM_ARRAY(index);
    end if;
  end process;

-------------------------------------------------------------------------------
-- writes :
-------------------------------------------------------------------------------

  assert not((WriteEn1='1') and (WriteEn2='1') and (AdrWrite1 = AdrWrite2))
    report "WRITE CONTENTION !"
    severity ERROR;

  -- both write routines are gathered to avoid the use of std_logic_vector
  process (AdrWrite1, DataWrite1, WriteEn1, AdrWrite2, DataWrite2, WriteEn2)
    variable index : integer;
--    variable lout : line;
  begin
    if (WriteEn1 = '1') then
      index := sulv_to_int(AdrWrite1);
      if (index /= 0) then
        RAM_ARRAY(index) <= DataWrite1;
--         write(lout, now);
--         write(lout, string'(" : writing "));
--         write(lout, DataWrite1);
--         write(lout, string'(" to index "));
--         write(lout, index);
--         writeline(output, lout);
      end if;
    end if;

    if (WriteEn2 = '1') then
      index := sulv_to_int(AdrWrite2);
      if (index /= 0) then
         RAM_ARRAY(index) <= DataWrite2;
      end if;
    end if;
  end process;

-- -------------------------------------------------------------------------------
-- -- spies
-- -------------------------------------------------------------------------------
  
--   process (DataWrite1)
--     variable lout : line;
--   begin
--     write(lout, now);
--     write(lout, string'(" DataWrite1 = "));
--     write(lout, DataWrite1);
--     writeline(output, lout);
--   end process;

--   process (AdrRead1)
--     variable lout : line;
--   begin
--     write(lout, now);
--     write(lout, string'(" AdrRead1 = "));
--     write(lout, AdrRead1);
--     writeline(output, lout);
--   end process;

end prototype;
