-------------------------------------------------------------------------------
-- sram2r3w.vhdl : a basic multiport SRAM bloc for building the F-CPU register set
-- created sat. feb. 9 04:40:36 GMT 2002 by whygee@f-cpu.org
--
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- This building block is to be replaced, whenever needed, by appropriate and
-- technology-dependent multiported RAM blocks.
--
-- The first problem is the multiporting : this block can be implemented with
-- several smaller blocks, for examples 3 blocks that provide 1 read and 3
-- writes per cycle.
--
-- The second problem is the timing : it is believed that the clock cycle is so
-- short that write and read to a same location can not occur. Shortly put :
-- the transmission time + setup + hold + read access delay is too much and
-- only read OR write is allowed (so it's only write access time + setup + hold
-- or read access time).
--
-- The third (and worst) problem is the clocking : it seems to be impossible to
-- spread the clock tree through all the R7 so i'm going to use "asynchronous"
-- logic and the rest will depend on a good timing... simply through the use of
-- "transparent latches" that require a few less transistors per bit and have
-- some potential of working faster.
--
-- In the end, it is going to depend on available technology. I bet on 6-T
-- register cells for the implementation.
--
-- Here is only the interface.
--
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;

entity sram3r2w is
  
  generic (
    width : natural  -- number of bits per register in the sub-block
  );

  port (
    AdrRead1, AdrRead2, AdrRead3, AdrWrite1, AdrWrite2 : in std_ulogic_vector(5 downto 0);
    DataWrite1, DataWrite2 : in std_ulogic_vector(width-1 downto 0);
    WriteEn1, WriteEn2 : in std_ulogic;
    DataRead1, DataRead2, DataRead3 : out std_ulogic_vector(width-1 downto 0)
    clk : in std_ulogic;
  );

end sram3r2w;
