--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- f-cpu/vhdl/configuration/clock_config.vhdl, clock configuration for the FC0
-- created Thu Sep  6 21:52:09 2001 by Yann GUIDON <whygee@f-cpu.org>
-- version Fri Sep  7 03:13:20 2001
--
-- This file describes the interface and the generic "features" of the
-- clock generator in f-cpu/vhdl/clock/clock.vhdl. Some parts will be
-- moved later to make this unit even more flexible.
--
-- WARNING : THIS IS VERY PRELIMINARY !!!!!

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;

package clock_config is

  -- change this parameter as needed. Synthesis might not like it.
  constant CLOCK_INVERTER_DELAY : time := 100 ps;  -- time to go through an inverter

  -- number of bits in the prescaler counters
  constant CLOCK_COUNTER_SIZE : natural := 5;

  -- number of bits in the phase comparators
  constant CLOCK_PHASE_ACC : natural := 4;
  
  -- number of bits that control the NCO frequency
  constant CLOCK_NCO_SIZE : natural := 5;

  -- minimum number of inverters in the loop : MUST BE ODD !
  constant CLOCK_NCO_MIN : natural := 3;

  -- log2 of the number of clock modes
  constant CLOCK_MODE_SIZE : natural := 3;
  
  subtype clock_mode_type is std_ulogic_vector(CLOCK_MODE_SIZE-1 downto 0);

  -- operation modes for the clock unit :
  constant CLOCK_MODE_DEFAULT :        clock_mode_type:= "000";
  constant CLOCK_MODE_INTERNAL :       clock_mode_type:= "001";
  constant CLOCK_MODE_EXTERNAL :       clock_mode_type:= "010";
  constant CLOCK_MODE_EXT_PRESCALED :  clock_mode_type:= "011";
  constant CLOCK_MODE_LOCKED_LOOP :    clock_mode_type:= "100";
  constant CLOCK_MODE_SLOW :           clock_mode_type:= "101";
  -- additional modes
  constant CLOCK_MODE_FAST :           clock_mode_type:= "110";

  -- Example for the format of the word received from the SR :
  type clock_control_type is
    record
      mode : clock_mode_type;
      prediv, premul : std_ulogic_vector(CLOCK_COUNTER_SIZE-1 downto 0);
      NCO : std_ulogic_vector(CLOCK_NCO_SIZE-1 downto 0);
    end record ;
  -- I don't think that using a record is a good idea.
  -- On top of that we must provide higher-level (abstract) functions,
  -- and apropriate HW so the clock speed doesn't make jumps -> power
  -- spikes and other electrical problems.

end; --  clock_config;

package body clock_config is
  -- empty. We may define the mapping from the SR to the fields but it is
  -- not very practical yet. see clock_control_type above.
end clock_config;
