--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- f-cpu/vhdl/clock/test_clock.vhdl, testbench for FC0's clock generator
-- created Wed Sep  5 09:08:08  2001 by Yann GUIDON <whygee@f-cpu.org>
-- Vanilla doesn't pass, as the clock entity doesn't.
-- version Mon Sep 10 07:14:32 2001 : YG tries to make the PLL work. unsuccessfully.
--
-- Remark : no "configuration" selection is done, the last architecture is used by default.
-- 

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.std_logic_textio.all;
    USE ieee.numeric_std.all;
    USE ieee.std_logic_arith.ALL;
LIBRARY std;
    USE std.textio.ALL;
LIBRARY work;
    USE work.clock_config.ALL;

Entity clock_tb is
   -- no I/O except for display.
end clock_tb;


Architecture arch1 of clock_tb is
-- in
 signal reset_in : Std_ulogic := '1';   -- external reset
 signal clock_in : Std_ulogic := '0';   -- external clock input
 signal clock_mode : clock_mode_type := CLOCK_MODE_LOCKED_LOOP;
 signal prediv, premul : std_ulogic_vector(CLOCK_COUNTER_SIZE-1 downto 0) := "11111";
       -- division factor for the external and internal clocks
 signal NCO : std_ulogic_vector(CLOCK_NCO_SIZE-1 downto 0) := "11111";  -- internal clock frequency

-- out
 signal clock_out : Std_ulogic;  -- clock output for the FC0
 signal clock_ok : Std_ulogic;   -- it is 1 if the output frequency is OK.

begin

-- map the module :
  clock_instance : entity work.clock
  port map(
    reset_in => reset_in,
    clock_in => clock_in,
    snore => '0',
    clock_ok => clock_ok,
    clock_out => clock_out,
    clock_mode => clock_mode,
    NCO => NCO,
    prediv => prediv,
    premul => premul
  );

--
-- now, let's have some fun !
   -- dumb whacky clock
  process
--    variable cpt : integer := 0;          -- cycle counter
    variable lout : line ;
  begin
    clock_mode <= CLOCK_MODE_LOCKED_LOOP;
    premul <= "11111";
    prediv <= "11111";
    NCO <= "11111";        -- min loop=3*200ps

    reset_in <= '1';
    wait for 10000 ns;
    reset_in <= '0';

    wait;

  end process;


--   process
--     variable lout : line ;
--   begin
--     wait until rising_edge(clock_out);

--     WRITE(lout,string'("| time : "));
--     WRITE(lout,now);
-- --     WRITE(lout,string'("   clock_out = "));
-- --     WRITE(lout,clock_out);
--     WRITELINE(OUTPUT, lout);

--   end process;

  process
  begin
      clock_in <= '1';
      wait for 5.653 ns;
      clock_in <= '0';
      wait for 5.653 ns;
    if reset_in = '0' then
      wait;
    end if;
  end process;
  
end;
