#!/bin/sh
# 
# f-cpu/install.sh
# created dim mar 31 01:31:08 2002 by whygee@f-cpu.org

echo " "
echo "     Hello, this is a little configuration and setup script"
echo "     for the F-CPU source code tree. It will run some detection"
echo "     and sanity checks to ensure that you can compile the sources."
echo " "

# some cut&paste from /etc/init.d/functions
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_WARNING="echo -en \\033[1;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"

function message_ok () {
  echo -n "     [ "
  $SETCOLOR_SUCCESS
  echo -n $*
  $SETCOLOR_NORMAL
  echo " ]"
}

function message_ko () {
  echo -n "     [ "
  $SETCOLOR_FAILURE
  echo -n $*
  $SETCOLOR_NORMAL
  echo " ]"
}

function message_info () {
  echo -n "     [ "
#  $SETCOLOR_WARNING
  echo -n $*
#  $SETCOLOR_NORMAL
  echo " ]"
}

# hint : parenthesis now are used to create subshells, so there is
# no problem with environment variables or directories. Things
# could even be parallelized if it was possible.
# They are also used to perform implicit IF/THEN/ELSE along
# with the || and && keywords. Ugly but light.
(

# step 1 : configuration
( 
  message_info "re-generating the configuration"
  cd configuration &&
  make &&
  message_ok "configuration ok"
) && (

# step : generating and test YGASM
# (nasm is used by fromfs but a custom replacement is needed)
  cd ygasm
) && (

# step : create and test the fromfs utilities
  message_info "fromfs utilities"
  cd fromfs &&
  . fromfs.sh &&
  message_ok "fromfs ok"
)


# step : tool detection


# step : running the testbenches


# step : compiling the whole CPU


# step : running a sample program

) || message_ko "OOooopsss....."
