-------------------------------------------------------------------------------
-- sram1r2w.vhdl : a small multiport SRAM vector for the register set's flag cache
-- created sat. feb. 9 04:40:36 GMT 2002 by whygee@f-cpu.org
-- updated Mon Jun 24 01:02:14 CEST 2002 by same, changing to type t_reg.
--       and removing WriteEn
--         Mon Jun 24 07:14:59 CEST 2002 : adapted from sram3r2w
--
--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENSE------------------------------
--
-- This SRAM building block is to be replaced, whenever needed, by appropriate
-- and technology-dependent multiported RAM blocks.
--
-- It's a copy&paste from the larger SRAM block that makes the register set.
--
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
LIBRARY work;
    USE work.FCPU_config.ALL;  -- for t_reg

entity sram1r2w is
  port (
    AdrRead, AdrWrite1, AdrWrite2 : in t_reg;
    DataWrite1, DataWrite2 : in std_ulogic;
    DataRead : out std_ulogic;
    clk : in std_ulogic
  );
end sram1r2w;

-------------------------------------------------------------------------------

architecture arch1 of sram1r2w is

  signal RAM_ARRAY : std_ulogic_vector(63 downto 1); -- the array.


  -- dirty hack that transforms the register address
  -- into an integer for use in the processes.
  -- it's a modified form of to_integer(t_reg).

  -- when the component is not connected or initialised,
  -- the addresses are "floating" and they trigger index
  -- errors so here we select address 0 by default.

  function sulv_to_int (sulv : t_reg) return reg_number is
    variable i : integer := 0;
    variable j : reg_number := 0;

  begin  -- sulv_to_int

    for i in sulv'high downto sulv'low loop
      j := j*2;
      if sulv(i) = '1' then
        j := j+1;
      else
        if sulv(i) /= '0' then
          return 0;   -- safety net because

-- important note : since Us and Xs etc. don't appear in real life, this function
-- does not represent the _real_ behaviour of the bank. Usually, when decoding
-- a "000000", the decoder does nothing (the corresponding address is not wired)

-- There is certainly a better way to do this.

        end if;
      end if;
    end loop;  -- i
    return j;
  end sulv_to_int;
  
begin  -- arch1 

-------------------------------------------------------------------------------
-- asynchronous read :
-------------------------------------------------------------------------------

  process (AdrRead)
    variable index : reg_number;
  begin
    index := sulv_to_int(AdrRead);
    if (index = 0) then
      DataRead <= '0';
    else
      DataRead <= RAM_ARRAY(index);
    end if;
  end process;

-------------------------------------------------------------------------------
-- writes :
-------------------------------------------------------------------------------

  -- both write routines are gathered in this process
  -- to avoid the use of std_logic_vector (resolution problems)
  process
    variable index1, index2 : reg_number;
  begin
    wait until rising_edge(clk);

    index1 := sulv_to_int(AdrWrite1);
    index2 := sulv_to_int(AdrWrite2);

    assert not((index1 /= 0) and (index1 = index2))
      report "WRITE CONTENTION !"
      severity ERROR;

    if (index1 /= 0) then
      RAM_ARRAY(index1) <= DataWrite1;
    end if;

    if (index2 /= 0) then
      RAM_ARRAY(index2) <= DataWrite2;
    end if;
  end process;

end arch1;
