--------------------------------------------------------------------------
-- f-cpu/vhdl/eu_rop2/test_rop2.vhdl - Yet Another ROP2 Testbench for the F-CPU
-- Copyright (C) 2001 Yann GUIDON (whygee@f-cpu.org)
--
-- created sam dec  1 05:17:51 GMT 2001
-- version jeu dec  6 17:35:53 GMT 2001
-- version lun dec 10 02:33:00 GMT 2001 : added rand() and explicit functional
--    testing. Missing : logarithmic vector generation but rand() is enough now.
-- version Thu Jul  4 05:00:05 2002 : riviera hicups on rand => renamed.
-- version Tue Jul 23 08:31:33 CEST 2002 : now a simple wrapper.
--
--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENSE------------------------------
--
-- This is now a little wrapper that reads stimuli from a HEX file.
--
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
    USE IEEE.std_logic_textio.all;
    USE std.textio.all;
LIBRARY work;
    USE work.FCPU_config.ALL;
    USE work.eu_rop2_xbar;
    USE work.eu_rop2;
    USE work.random.all;

Entity test_rop2 is
  generic (FILENAME : string := "vect_rop2.hex" );
end test_rop2;

Architecture arch1 of test_rop2 is

  file stimulus: TEXT open read_mode is FILENAME;

  signal l_ROP2_function : Std_ulogic_vector(2 downto 0);
  signal l_ROP2_function_bit0, l_ROP2_function_bit1, l_ROP2_function_bit2,
    l_ROP2_function_bit3 : Std_ulogic_vector((MAXSIZE *2)-1 downto 0);
  signal l_ROP2_in_A, l_ROP2_in_B, l_ROP2_in_C, l_ROP2_out : F_VECTOR;
  signal l_ROP2_mode : Std_ulogic_vector(1 downto 0);

  component EU_ROP2_XBAR is
    port(
      ROP2_function : in Std_ulogic_vector(2 downto 0);
      ROP2_function_bit0,
      ROP2_function_bit1,
      ROP2_function_bit2,
      ROP2_function_bit3 : out Std_ulogic_vector((MAXSIZE *2)-1 downto 0)
    );
  end component;

  component EU_ROP2 is
  port(
    ROP2_in_A,
    ROP2_in_B,
    ROP2_in_C : in F_VECTOR;
    ROP2_function_bit0,
    ROP2_function_bit1,
    ROP2_function_bit2,
    ROP2_function_bit3 : in Std_ulogic_vector((MAXSIZE *2)-1 downto 0);
    ROP2_mode : in Std_ulogic_vector(1 downto 0);
    -- Combine_size : in Std_ulogic_vector(1 downto 0); -- unused ATM. Byte chuncks only.
    ROP2_out : out F_VECTOR
  );
  end component;

begin   --  arch1 of test_rop2

  -- Components under test :
  xbar: eu_rop2_xbar port map (
      ROP2_function => l_ROP2_function,
      ROP2_function_bit0 => l_ROP2_function_bit0,
      ROP2_function_bit1 => l_ROP2_function_bit1,
      ROP2_function_bit2 => l_ROP2_function_bit2,
      ROP2_function_bit3 => l_ROP2_function_bit3
  );

  rop2: eu_rop2 port map (
      ROP2_in_A => l_ROP2_in_A,
      ROP2_in_B => l_ROP2_in_B,
      ROP2_in_C => l_ROP2_in_C,
      ROP2_function_bit0 => l_ROP2_function_bit0,
      ROP2_function_bit1 => l_ROP2_function_bit1,
      ROP2_function_bit2 => l_ROP2_function_bit2,
      ROP2_function_bit3 => l_ROP2_function_bit3,
      ROP2_mode  => l_ROP2_mode,
      ROP2_out => l_ROP2_out
  );

  -- test vectors :
  testbench : process is
    variable k : integer := 0;
    variable lin, lout : line;

    variable v_ROP2_mode, v_ROP2_function : std_ulogic_vector(3 downto 0);
      -- riviera doesn't like hread() on non-multiples of 4.
    variable v_ROP2_in_A, v_ROP2_in_B, v_ROP2_in_C, exp_out : F_VECTOR;

    procedure dumpstate is
    begin
      write(lout, string'(" ***************  ERROR !!! ***************** "));
      writeline(output, lout);
      write(lout, string'("line #"));
      write(lout, k);

      write(lout, string'(", mode="));
      write(lout, l_ROP2_mode);
      case l_ROP2_mode is
        when ROP2_DIRECT_MODE => write(lout, string'(" (DIRECT)"));
        when ROP2_AND_MODE    => write(lout, string'(" (AND)"));
        when ROP2_OR_MODE     => write(lout, string'(" (OR)"));
        when ROP2_MUX_MODE    => write(lout, string'(" (MUX)"));
        when others           => assert false severity FAILURE;
      end case;

      write(lout, string'(", function="));
      write(lout, l_ROP2_function);

      case l_ROP2_function is
        when ROP2_AND  => write(lout, string'(" (AND)"));
        when ROP2_ANDN => write(lout, string'(" (ANDN)"));
        when ROP2_XOR  => write(lout, string'(" (XOR)"));
        when ROP2_OR   => write(lout, string'(" (OR)"));
        when ROP2_NOR  => write(lout, string'(" (NOR)"));
        when ROP2_XNOR => write(lout, string'(" (XNOR)"));
        when ROP2_ORN  => write(lout, string'(" (ORN)"));
        when ROP2_NAND => write(lout, string'(" (NAND)"));
        when others    => assert false severity FAILURE;
      end case;
      writeline(output, lout);

      write(lout, string'("ROP2_in_A "));
      write(lout, l_ROP2_in_A);
      writeline(output, lout);

      write(lout, string'("ROP2_in_B "));
      write(lout, l_ROP2_in_B);
      writeline(output, lout);

      write(lout, string'("ROP2_in_C "));
      write(lout, l_ROP2_in_C);
      writeline(output, lout);

      write(lout, string'("expected : "));
      write(lout, exp_out);
      writeline(output, lout);

      write(lout, string'("  expected : "));
      write(lout, l_ROP2_out);
      writeline(output, lout);

    end procedure;

  begin
    while not endfile(stimulus) loop
      k := k+1;

      -- read the stimuli
      readline(stimulus, lin);
      hread(lin, v_ROP2_function);
      hread(lin, v_ROP2_mode);
      hread(lin, v_ROP2_in_A);
      hread(lin, v_ROP2_in_B);
      hread(lin, v_ROP2_in_C);
      hread(lin, exp_out);

      l_ROP2_function <= v_ROP2_function (2 downto 0);
      l_ROP2_mode <= v_ROP2_mode (1 downto 0);
      l_ROP2_in_A <= v_ROP2_in_A;
      l_ROP2_in_B <= v_ROP2_in_B;
      l_ROP2_in_C <= v_ROP2_in_C;

      wait for 1 ns;

      if l_ROP2_out /= exp_out then
        dumpstate;
        wait for 1 ns;
        assert false
          report "unexpected result"
          severity FAILURE;
      end if;

    end loop;

    write(lout, k);
    write (lout, string'(" vectors tested, ROP2 seems OK."));
    writeline(output, lout);
    wait;  -- stop the simulation counter.
  end process;

end;   --  arch1 of test_rop2
