--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENSE------------------------------
--
-- package : random in f-cpu/vhdl/common/random_simple
-- created Tue Sep 11 03:09:44 2001 by whygee@f-cpu.org
-- version Wed Sep 12 03:55:13 2001 : compiles with simili and vanilla.
-- version Wed Sep 12 06:47:04 2001 : simplified even more :-)
-- version Thu Jun 27 06:38:52 2002 : ncsim port is more difficult than expected.
-- version Thu Jul  4 04:55:05 2002 : riviera hicups => renamed to rand_vector,
--                                     rand_size and rand_bit
--
-- Read random.txt for some explanations about this package.
--
-- This one implements a very dumb version that is "plugged" to
-- /dev/urandom. It is simplified to the extreme and optimisations
-- are removed, in order to work wherever possible.
--
-- It is a compromise between random_clear.vhdl and random_file.vhdl,
-- it brings the basic functionality of the first but is more limited.
-- it is not "optimised" for short files and wraparound is not supported,
-- as ncsim seems to dislike file_open()...
--
-------------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
    USE ieee.std_logic_textio.all;
LIBRARY std;
    USE std.textio.ALL;

package random is

  type byte_stream is file of character ;
  file random_file : byte_stream open read_mode is "/dev/urandom";
      -- it is opened here -> no "wrap around" possible.

  function rand_vector (var : in std_ulogic_vector)  -- the parameter is necessary to determine
    return std_ulogic_vector;                 --  the size (range) of the vector

  function rand_size (size : natural)  -- this is a "wrapper" that assumes a
    return std_ulogic_vector;     -- std_ulogic_vector(size-1 downto 0) as output.

  function rand_bit    -- this "wrapper" returns a single bit.
    return std_ulogic;

  -- some "buttons" if you want to control the function more tightly :
  type init_type is (reset, set, random);
  constant random_mode : init_type := random;
  constant random_verbose : boolean := false;
  
end random;


package body random is

  function rand_vector (var : in std_ulogic_vector)
    return std_ulogic_vector is

    variable t : std_ulogic_vector(var'range);
    variable u : std_ulogic_vector(8 downto 1);
    variable j : character;
    variable k : integer := 0;
    variable status : file_open_status;

  begin

    if random_mode = random then

--      -- This part deals with file wrap-around and the previous file status.
--      file_open(status, random_file, RANDOM_NAME, read_mode);
--      -- this will silently ignore the case when random_file is already open.
--      if random_verbose = true then
--        assert status /= status_error
--          report " random file already opened"
--          severity note;
--        assert status /= open_ok
--          report " random file opened"
--          severity note;
--      end if;

--      -- manage the byte buffer

      for i in var'range loop


        if k <= 0 then             -- time to get one more byte
--          if endfile(random_file) then
--            file_close(random_file);    -- wrap around
--          end if;
--          file_open(status, random_file, RANDOM_NAME, read_mode);
--          -- this will also silently ignore the case when random_file is already open.
--          if random_verbose = true then
--            assert status /= open_ok
--              report " random file successfully reopened"
--              severity note;
--          end if;
          read(random_file, j);
          u := std_ulogic_vector(to_unsigned(character'pos(j), 8));
          k := 8;
        end if;

        t(i) := u(k);
        k := k-1;

      end loop;

    else
      if random_mode = reset then
        t := (others=>'0');
      else
        if random_mode = set then
          t := (others=>'1');
        end if;
      end if;
    end if;
    return t;
  end;

    -- this is a "wrapper" that assumes a std_ulogic_vector(size-1 downto 0) as output.
  function rand_size (size : natural)
    return std_ulogic_vector
  is
    subtype st is std_ulogic_vector(size-1 downto 0);
    variable t : st;
  begin
    t := rand_vector(t);
    return t;
  end;

    -- this is a "wrapper" that returns a single bit.
  function rand_bit
    return std_ulogic
  is
    variable t : std_ulogic_vector(0 downto 0);
  begin
    t := rand_vector(t);   -- call the wrapped function
    return t(0);
  end;

end random;
