/*
  f-cpu/c/xbar/eu_asu.h - Xbar for the F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 19 July 2002 13:30

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

#ifndef XBAR_H
#define XBAR_H

#include <f-cpu_config.h>

/* control inputs for xbus-read: */
u8   xbar_EU_nr;
u8   xbar_sch_bypass_r0;       /* bypas detection from scheduler */
u8   xbar_sch_bypass_r1;       
u8   xbar_sch_bypass_r2;       
u8   xbar_r0_port_nr;         /* from the decoder */
u8   xbar_r1_port_nr;
u8   xbar_r2_port_nr;

bool xbar_use_r0;  /* from the decoder                 */
bool xbar_use_r1;  /* if one of these are true we must */
bool xbar_use_r2;  /*      use a bypass (if avalable)  */

/* control inputs for xbus-write: */
u8   xbar_w0_port_nr;         /* nr of EU output port */
u8   xbar_w1_port_nr;         /* nr of EU output port */

/* data inputs: */
UMAX xbar_reg_R0;             /* connected to register read ports */
UMAX xbar_reg_R1;
UMAX xbar_reg_R2;
UMAX xbar_write_from_port[25];/* connected to the outputs of the EU's */

/* data outputs : */
UMAX xbar_reg_W0;             /* connected to register write ports */
UMAX xbar_reg_W1;
UMAX xbar_read_to_port_r0[16];/* connected to the input 0 of the EU's */
UMAX xbar_read_to_port_r1[16];/* connected to the input 1 of the EU's */
UMAX xbar_read_to_port_r2[16];/* connected to the input 2 of the EU's */

/* internal FF between stages: */
UMAX tmp_xbar_bus_W0;         /* delayed w0 bus, used for delayed bypass */
UMAX tmp_xbar_bus_W1;         /* delayed w1 bus, used for delayed bypass */

/* problem : they should be enums !! */

static inline void cycle_asu (void);

#endif /* XBAR_H */


















































