-- register set for the FC0
--
--
--
--
--
--
--
--
--
--
--
--
--
--
--
--
-- here is some "meat" to start with, copied from a book :
--  "VHDL for logic synthesis" 2nd ed. by  Andrew Rushton
-- it will have to be deeply modified : 3 read ports and 2 write ports,
-- with subword enables !
--
--  This version compiles with Vanilla and simili


library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity r7 is
  generic (
    w, n : natural);
  port (
    d         : in  signed (w-1 downto 0);
    ck, write : in  std_logic;
    addr      : in  unsigned(n-1 downto 0);
    q         : out signed(w-1 downto 0));
end r7;

architecture behaviour of r7 is
  signal addr_i : natural range 0 to 2**n - 1;
  type store_type is array (0 to 2**n - 1) of signed(w-1 downto 0);
  signal store : store_type;
begin  -- behaviour

  addr_i <= to_integer(addr);

  process
  begin
    wait until rising_edge(ck);
    store(addr_i) <= d;
  end process;

  q <= store(addr_i);

end behaviour;
