--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- package : random
-- created Tue Sep 11 03:09:44 2001 by whygee@f-cpu.org
-- version Wed Sep 12 03:55:13 2001 : compiles with simili and vanilla.
-- version Wed Sep 12 06:47:04 2001 : simplified even more :-) Graham, your
-- books are too useful :-)
-- 
-- The purpose of this package is to provide an early (design-time)
-- way to test that a circuit does not reach an unstable state when
-- it is powered on.
--
-- IDEALLY, ALL "VARIABLES" SHOULD BE INITIALIZED WITH THIS PACKAGE !
--
-- this is intended for simulation only. Run a few times, to be sure that
-- different values are tested.
--
-- The problem is that it is not easy to create "real" random sequences,
-- we would get the same sequence all the time if an internal generator is
-- used. The first idea here is to read the special file /dev/random through textio.
--
-- But there are two problems : /dev/random is slow (several bytes/second)
-- and several platforms don't have this feature. Anyway the input can come
-- from any file, preferably a compressed archive or any file without
-- repetitive sequences (ie: entropy). The RANDOM_NAME
-- value allows you to change the file name.
--
-- if you want to use /dev/random, either make a dump (with the command
--  $ dd if=/dev/random of=random bs=1024 count=20 ) or create a symlink :
--  $ ln -s /dev/random random (in the proper directory)
-- Warning concerning /dev/random : the above lines will only yield
-- a few hundred bytes at a time ! make experiments.
-------------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;

-- for the tests :
    USE ieee.std_logic_textio.all;
LIBRARY std;
    USE std.textio.ALL;


package random is

  constant RANDOM_NAME : string := "random";  -- the input file.
  -- "ln -s /dev/random random" is used by default, otherwise you could create
  -- such a "real" file or simply link to a file .gz

  -- global textio variables (so the file is opened only once during elaboration).
  type byte_stream is file of character ;  --  byte;
  file random_file : byte_stream open read_mode is RANDOM_NAME;

  function rand (var : in std_ulogic_vector)  -- the parameter is
    -- necesary to determine the size (range) of the vector
    return std_ulogic_vector;

end random;


package body random is

  function rand (var : in std_ulogic_vector)
    return std_ulogic_vector is

    variable t : std_ulogic_vector(var'range);
    variable u : std_ulogic_vector(8 downto 1);
    variable j : character;
    variable k : integer := 0;
--     variable lineno : integer := 0;
--     variable l : line;

  begin
    for i in var'range loop
      if k <= 0 then
--        if endfile(random_file) then
--          file_close(random_file);
--    doesn't work :   file_open(random_file, RANDOM_NAME, read_mode);
--        end if;
--        writeline(output,l);
        assert not endfile(random_file)
          report " EOF of random file !!!"
          severity FAILURE;
        -- i sometimes get spurious problems with the symlink.
        -- is /dev/random too slow ???
        read(random_file, j);
        u := std_ulogic_vector(to_unsigned(character'pos(j), 8));
--         write(l, lineno);
--        lineno := lineno + 1;
--         write(l,string'(": reading string="));
--         write(l,u);
--         write(l,string'("  out: "));
        k := 8;
      end if;

      t(i) := u(k);
--      write(l,u(k));
      k := k-1;

    end loop;
--    writeline(output,l);
    return t;
  end;

end random;
