#!/bin/sh
#  YG's script for compiling the F-CPU VHDL core
# with the command-line Vanilla VHDL.
# created Fri Sep  7 04:22:28 2001 by whygee@f-cpu.org
# version Sat Sep 15 05:48:47 2001
# updated Mon Sep 17 19:11:37 2001 : made more portable by MR

# use /bin/sh unless CONFIG_SHELL is set
: ${CONFIG_SHELL=/bin/sh}

# check if the detection is already performed :
if [ ! -f tools.env ]
then
    ${CONFIG_SHELL} tool_configure.sh > tools.env
fi
# load configuration
. ./tools.env

# check the result
case "$VANILLA_STATIC" in
    on)
	analyze() { va87 -x "$1"; }
	;;
    off)
	analyze() { echo "analyze -x $1" | vv87; }
	;;
    *)
	echo >&2 " # could not run Vanilla : aborting."
	exit 1
	;;
esac

vanilla() {
    echo " - making $1"
    if analyze "$1" | grep ERROR; then
	echo >&2 'OOOPS ! something went wrong...'
	exit 1
    fi
}

#The following strings are formed with the rule : directory_name='file1 file2 file_n'
   configuration='f-cpu_config.vhdl f-cpu_opcodes.vhdl clock_config.vhdl'
          common='generic_adder.vhdl random.vhdl'
	   clock='clock_vanilla.vhdl'
         eu_rop2='rop2_xbar.vhdl rop2_unit.vhdl'
 	  eu_asu='iadd.vhdl asu.vhdl'
        toplevel='toplevel.vhdl'

# list of the directory names
     directories='configuration common clock eu_rop2'

#compile everything :
for j in $directories
do
    eval k=\${$j}	# this trick is even better :) --MR
    for l in $k
    do
	vanilla "$j/$l"
    done
done
