/*

f-cpu/qdcpoc/register_set.c
created Sat Aug  4 18:51:03 2001 by Yann Guidon <whygee@f-cpu.org>

(C) 2001 YG, all rights reserved.
* don't try to work on this, it's really ugly and a waste of time.
* don't spread outside the F-CPU team
* it's not even sure that it will compile.

pre-VHDL study for the register set. This is still part of the
QDCPOC so be careful because not everything is definitive !!!


   Global variables :

* interface for reading in the R7 :
    OUT :  UMAX R7_read_port_0, R7_read_port_1, R7_read_port_2;
    IN :   int R7_read_address_0, R7_read_address_1, R7_read_address_2; 
* interface for writing in the R7 :
    IN :   UMAX R7_write_mask_0, R7_write_port_0, R7_write_mask_1, R7_write_port_1;
           int R7_write_address_0, R7_write_address_1;
* flags :
    OUT :
      u64  (64 bits, one bit per register)
         R7_ZERO   each bit is 1 if the corresponding register is not 0 (it's a 64-bit OR)
         R7_LSB    gives the value of the LSB of the corresponding register
         R7_MSB;   gives the value of the MSB of the corresponding register

MISSING : ROP2 BYPASS

  Local variables : (don't put them on the stack !!!)
*/

u8 R7_null_flags[64]; /* each char is 0 if the corresponding reg. is 0 */

typedef union {
  u64 r;
  struct {
    u8  bank0;   /* beware on SUN/MAC : endian problem ? */
    u8  bank1;
    u16 bank2;
    u16 bank3;
    u16 bank4;
  } s; 
} type_register;

type_register R7_bank[64]; /* beware ! R7_bank[0]=0 !!! */


void fc0_cycle_register_set() {
  type_register t0;
  u64 t1;
  SMAX t2, t3;
  u8 i;

  /* Stage 1 : read the registers */

  R7_read_port_0 = R7_bank[R7_read_address_0].r;
  R7_read_port_1 = R7_bank[R7_read_address_1].r;
  R7_read_port_2 = R7_bank[R7_read_address_2].r;
    /* looks simple, doesn't it ? */


  /* Stage 2 : write the registers + update the flags */

/*    Concerning the "side effects" :
   * Register #0 is hardwired to ZERO.
   * the scheduler issue part ensures that reg#0 is never written to
     so we don't have to check here whether reg#0 is written to,
     or if two ports write to the same register. */

  /* 2.1 : write enable for port 0 */
  t0.r = R7_write_port_0;
  t1 = 1LL << R7_write_address_0; /* create a mask, pure C stuff. */
  i = R7_null_flags[R7_write_address_0];

  if ((R7_write_mask_0 & 1)!=0) {
    R7_bank[R7_write_address_0].s.bank0 = t0.s.bank0;

    /* update the LSB flag */
    t2 = ~((t0.s.bank0 & 1)-1); /* for the LSB, 0 or -1L with nasty trick to propagate the LSB */
    R7_LSB = (R7_LSB & ~t1) | (t2 & t1);

    /* update the ZERO flag */
    if (t0.s.bank0 != 0)
      i |= 1;
    else
      i &= ~1;
  }

  if ((R7_write_mask_0 & 2)!=0) {
    R7_bank[R7_write_address_0].s.bank1 = t0.s.bank1;
    if (t0.s.bank1 != 0) i |= 2; else i &= ~2;
  }

  if ((R7_write_mask_0 & 4)!=0) {
    R7_bank[R7_write_address_0].s.bank2 = t0.s.bank2;
    if (t0.s.bank2 != 0) i |= 4; else i &= ~4;
  }

  if ((R7_write_mask_0 & 8)!=0) {
    R7_bank[R7_write_address_0].s.bank3 = t0.s.bank3;
    if (t0.s.bank3 != 0) i |= 8; else i &= ~8;
  }
  if ((R7_write_mask_0 & 16)!=0) {
    R7_bank[R7_write_address_0].s.bank4 = t0.s.bank4;
    if (t0.s.bank4 != 0) i |= 16; else i &= ~16;

    /* update the MSB */
    t3 = (SMAX)t0.r >> 63;      /* for the MSB, 0 or -1L through sign propagation */
    R7_MSB = (R7_MSB & ~t1) | (t3 & t1);
  }

  R7_null_flags[R7_write_address_0] = i;

  /* OR of the partial results : */
  if (i != 0)
    R7_ZERO |=  t1;
  else
    R7_ZERO &= ~t1;



  /* 2.2 : write enable for port 1
      (cut, paste and rename of the above code)
      [comments have been removed] */
  t0.r = R7_write_port_1;
  t1 = 1LL << R7_write_address_1;
  i = R7_null_flags[R7_write_address_1];

  if ((R7_write_mask_1 & 1)!=0) {
    R7_bank[R7_write_address_1].s.bank0 = t0.s.bank0;

    /* update the LSB flag */
    t2 = ~((t0.s.bank0 & 1)-1);
    R7_LSB = (R7_LSB & ~t1) | (t2 & t1);

    /* update the ZERO flag */
    if (t0.s.bank0 != 0)
      i |= 1;
    else
      i &= ~1;
  }

  if ((R7_write_mask_1 & 2)!=0) {
    R7_bank[R7_write_address_1].s.bank1 = t0.s.bank1;
    if (t0.s.bank1 != 0) i |= 2; else i &= ~2;
  }

  if ((R7_write_mask_1 & 4)!=0) {
    R7_bank[R7_write_address_1].s.bank2 = t0.s.bank2;
    if (t0.s.bank2 != 0) i |= 4; else i &= ~4;
  }

  if ((R7_write_mask_1 & 8)!=0) {
    R7_bank[R7_write_address_1].s.bank3 = t0.s.bank3;
    if (t0.s.bank3 != 0) i |= 8; else i &= ~8;
  }
  if ((R7_write_mask_1 & 16)!=0) {
    R7_bank[R7_write_address_1].s.bank4 = t0.s.bank4;
    if (t0.s.bank4 != 0) i |= 16; else i &= ~16;

    t3 = (SMAX)t0.r >> 63;
    R7_MSB = (R7_MSB & ~t1) | (t3 & t1);
  }

  R7_null_flags[R7_write_address_1] = i;

  if (i != 0)          /* final OR */
    R7_ZERO |=  t1;
  else
    R7_ZERO &= ~t1;

  /* #define TEST_BIST_R7 */
#ifdef TEST_BIST_R7
  /* test stuck at 1 : */
  R7_bank[14].r |= 1LL << 36;
#endif

}
