  /*
      f-cpu/ygasm/ygasm.y : syntactical analyser for the F-CPU assembler.
      hacked Mon Jul 16 02:14:39 by Yann Guidon
      adapted from the PPCM2 which is adapted from GRAZER which is...

      version : Fri Jul 27 04:58:33 2001 : added move & rop2/MUX
      missing : SIMD flag and size flags.

      version : Thu Aug  2 04:18:57 2001 : changing the instruction word bit ordering.
      version : Tue Aug 21 07:48:55 2001 : corrected a little side effect with CMOVE.
              the current implementation does not yet contain MR's syntax.
  */

%{

  /* we're limited to "long long int"s anyway. */
#define YYSTYPE u64

%}


%token YSYMB YNEWSYMB YREG YDB YDD YDQ YDP YDS YORG YALIGN
%token YNUM YAT YSHR YSHL YMSB YLSB YEQU YDIFF YMUX YCOMBINE_AND YCOMBINE_OR
%token YROP2 YROP2I YLOADCONS YLOADCONSX YMOVE YCMOVE
%token YNOP

 /* fixes the precedence of the operators for the
   evaluation of expr (see at the end of the file) */
%right '='
%left '~'
%left '&'
%left '|'
%left '^'
%left YSHL YSHR
%left '+'
%left '-'
%left '*'
%left '/'
%left '%'
%left STRONG


%%
  /* entry point : a programme is a succession of instructions and pseudo_instructions */
programme : /* nothing */
          | programme pseudo_instruction
          | programme instruction ';' { emit_instruction(); }
          ;

pseudo_instruction :
     YNEWSYMB ':' { referenced_symbol->value = current_PC; } /* assign the PC value to the new symbol */
   | YSYMB    '=' expr ';' { referenced_symbol->value = $3 } /* simple assignation */
   | YNEWSYMB '=' expr ';' { referenced_symbol->value = $3 } /* simple assignation (with symbol creation) */
   | YALIGN expr ';'       { align_pc($2); }
   | YORG   expr ';'       { current_PC = $2; }
/*   | data datalist ';' */
/*   | output_redirection ';' */
/*   | symbol pre-declaration */
;

/* instruction forms and variants : */
instruction : instimm161w
            | instcond1r1w
            | inst1r1w
            | inst2r1w   /* this part comprises 3R1W and 2R2W implicitely */
            | instimm81r1w
            | other_instructions
            ;

/*************************
    for cmove and cjump :
 *************************/

instcond1r1w : opcond conditional ',' YREG ',' YREG  {  reg_src2 = $4; reg_dest = $6 } ;

opcond : YCMOVE { opcode = OP_MOV; /* JMP will be added later. */ };

conditional : YREG opt_bit cmp expr {
  reg_src1 = $1;
  if ($4!=0)
    ygasm_error("invalid value for condition (must be 0)",NULL);

} ;

opt_bit : /* if nothing : condition is zero */
        | YMSB { current_instruction |= (CONDITION_MSB << 19); }
        | YLSB { current_instruction |= (CONDITION_LSB << 19); }
        ;

cmp : YEQU | YDIFF { current_instruction |= (1 << 21); } ;

/*************************
   for move (and more) :
 *************************/

inst1r1w : op1r1w YREG ',' YREG  {  reg_src2 = $2; reg_dest = $4 } ;

op1r1w : YMOVE { opcode = OP_MOV; };
/* more will be added here soon */


/*************************
      for 2R1W ops :
 *************************/

inst2r1w : op2r1w YREG ',' YREG ',' YREG  {  reg_src1 = $2; reg_src2 = $4; reg_dest = $6 } ;

op2r1w : YROP2               { current_instruction |= (OP_ROP2 << 24) | $1 | (ROP2_DIRECT_MODE << 18); }
       | YROP2 YCOMBINE_AND  { current_instruction |= (OP_ROP2 << 24) | $1 | (ROP2_AND_MODE    << 18); }
       | YROP2 YCOMBINE_OR   { current_instruction |= (OP_ROP2 << 24) | $1 | (ROP2_OR_MODE     << 18); }
       | YMUX                { current_instruction |= (OP_ROP2 << 24) |      (ROP2_MUX_MODE    << 18); }
       ;

/* more will be added here soon */



/*************************
       for IMM81R1W ops :
 *************************/

instimm81r1w : opimm8 arg_imm8 ',' YREG ',' YREG  { reg_src2 = $4; reg_dest = $6 } ;

opimm8 : YROP2I { opcode = OP_ROP2I | $1;  };
/* more will be added here soon */

arg_imm8 : expr {
  /* verify if we will loose bits in the assignation : */
  s64 a = $1;
  if ((a >> 8)!=(a >> 63)) {
    ygasm_warning("value out of 8-bit range [=>truncating]",NULL);                   
  }
  imm8 = $1;
} ;


/*************************
     for loadcons(x) :
 *************************/


instimm161w : opimm16 shift_imm16 arg_imm16 ',' YREG { reg_dest = $5 } ;

opimm16 : YLOADCONS  { opcode = OP_LOADCONS; }
        | YLOADCONSX { opcode = OP_LOADCONSX; }
        ;

shift_imm16 : '[' expr ']' {     /* warning, the syntax may change. */
  if (($2 >> 4)!=0) /* check if 0 < $2 < 15 */
    ygasm_error("invalid shift count for LOADCONS",NULL);
  current_instruction |= (($2 & 15) << 22);
};

arg_imm16 : expr {
  /* verify if we will lose bits in the assignation : */
  s64 a = $1;
  if ((a >> 16)!=(a >> 63)) {
    ygasm_warning("value out of 16-bit range [=>truncating]",NULL);                   
  }
  imm16 = $1;
} ;

other_instructions : YNOP ; /* nothing to do */

   /* All the expressions
      (this is used to compute stuff with labels or constants.)
   */
expr	: '(' expr ')'	          { $$ = $2; }
        | YSYMB	                  { $$ = $1; }
        | YAT	                  { $$ = $1; }
	| YNUM	                  { $$ = $1; }
	| '-' expr %prec STRONG   { $$ = -$2; }
	| expr '-' expr           { $$ = $1 - $3; }
	| expr '+' expr           { $$ = $1 + $3; }
	| expr '*' expr           { $$ = $1 * $3; }
	| expr '/' expr           { $$ = $1 / $3; }
	| expr '%' expr           { $$ = $1 % $3; }
	| expr '&' expr           { $$ = $1 & $3; }
	| expr '|' expr           { $$ = $1 | $3; }
	| expr '^' expr           { $$ = $1 ^ $3; }
	| expr YSHL expr          { $$ = $1 << $3; }
	| expr YSHR expr          { $$ = $1 >> $3; }
	| '~' expr %prec STRONG   { $$ = ~ $2; }
	| '!' expr %prec STRONG   { $$ = ! $2; }
	;

%%
