/*

 f-cpu/ygasm/ygasm.l : lexical analyzer for the F-CPU ASM
 derived from the (old) PPCM, GRAZER and F-CPU projects.
 this preprocessor does recursive file includes, defines and ifdefs...
 This is NOT CPP but flexible enough to avoid using it.
 Maybe one day we'll even do some macro expansion ?

 KNOWN PROBLEMS:
 - too few overflow checks, i should make byte-based
   multiprecision int routines one day.
 - The Include and define routines don't catch the comments !
 - i should check whether #defines can be caught in an endless loop :
   #define a b
   #define b a
   a

 MISSING: strings and other features.

 * Sept 15, 1999 : adapted for the F-CPU : CPU-specific stuffs began at line 148
 * sam Apr 29 07:42:54 2000 : adapted for the PPCM
 * Sun Jul 15 17:41:37 2001 : back to some F-CPUing !
 * Sat Aug 11 20:01:13 2001 : corrected a youth bug (argv--)

 */

 /* the file swapping is "manually" handled in YY_INPUT */
%option noyywrap
 /* all recognised keywords are not tested against case */
%option caseless
%array

 /* avoids problems when compiling on some platforms */
%option never-interactive

 /* 'include' state */
%x incl

 /* 'define' state */
%x def1

 /* 'ifdef' states */
%x ifdef
%x ifndef
%x skip

 /* size postfixes states */


 /*
  *    LEXICAL RULES
  */

ID [_a-zA-Z][_a-zA-Z0-9]{0,31}

%%

 /*
  * COMMENTS
  */

"//".*       {  /* nothing */ }

"/*"         {  /* eat up multiple-line comments */
   register int _c;
   for(;;) {
      _c=input();
      switch(_c)
      {
         case '/':  if (count_nested_comments<enable_nested_comments
                         && (_c=input())=='*')
                      count_nested_comments++;
                    break;
         case '*':  do _c=input(); while (_c=='*');
                    if (_c=='/')
                    {
                      if (count_nested_comments==0)
                        goto end_comment;    /* found the end */
                      count_nested_comments--;
                      break;
                    }
      }
   }
end_comment:
}

 /*
  *
  *  KEYWORDS: add your own tokens here
  *
  */

DB            { return YDB; }
DW            { return YDW; }
DD            { return YDD; }
DQ            { return YDQ; }
DP            { return YDP; }
DS            { return YDS; }
ORG           { return YORG; }
ALIGN         { return YALIGN; }
"@"           { yylval = current_PC; return YAT; }
"<<" 	      { return YSHL; }
">>"   	      { return YSHR; }
NOP           { return YNOP; }
LOADCONS      { return YLOADCONS; }
LOADCONSX     { return YLOADCONSX; }
MOVE          { return YMOVE; }
CMOVE         { return YCMOVE; }
".lsb"	      { return YMSB; }
".msb"	      { return YLSB; }
"=="	      { return YEQU; }
"!="	      { return YDIFF; }
MUX           { return YMUX; }
".and"        { return YCOMBINE_AND; }
".or"         { return YCOMBINE_OR; }
AND           { yylval = FUNCTION_AND  ; return YROP2; }
ANDN          { yylval = FUNCTION_ANDN ; return YROP2; }
XOR           { yylval = FUNCTION_XOR  ; return YROP2; }
OR            { yylval = FUNCTION_OR   ; return YROP2; }
NOR           { yylval = FUNCTION_NOR  ; return YROP2; }
XNOR          { yylval = FUNCTION_XNOR ; return YROP2; }
ORN           { yylval = FUNCTION_ORN  ; return YROP2; }
NAND          { yylval = FUNCTION_NAND ; return YROP2; }
ANDI          { yylval = FUNCTION_AND  ; return YROP2I; }
ANDNI         { yylval = FUNCTION_ANDN ; return YROP2I; }
XORI          { yylval = FUNCTION_XOR  ; return YROP2I; }
ORI           { yylval = FUNCTION_OR   ; return YROP2I; }
NORI          { yylval = FUNCTION_NOR  ; return YROP2I; }
XNORI         { yylval = FUNCTION_XNOR ; return YROP2I; }
ORNI          { yylval = FUNCTION_ORN  ; return YROP2I; }
NANDI         { yylval = FUNCTION_NAND ; return YROP2I; }

  /*
 "u8"			{ yylval =  8+2; return YTYPE; }
 "u16"			{ yylval = 16+2; return YTYPE; }
 "u32"			{ yylval = 32+2; return YTYPE; }
 "u64"			{ yylval = 64+2; return YTYPE; }
 "s8"			{ yylval =  8+3; return YTYPE; }
 "s16"			{ yylval = 16+3; return YTYPE; }
 "s32"			{ yylval = 32+3; return YTYPE; }
 "s64"			{ yylval = 64+3; return YTYPE; }
 "SMAX"			{ yylval = -1; return YTYPE; }
 "UMAX"			{ yylval = -2; return YTYPE; }
 "string" ==> char strings

 ".lsb"		        { return YMSB; }
 ".msb"		        { return YLSB; }
 "abs"		        { return YABS; }
 "SIMD"		        { return YSIMD; }
 */


r(([0-5]?[0-9])|(6[0-3]))        { /* standard registers 0 to 63 */
  yylval=yytext[1]-'0';
  if (yyleng==3)
    yylval=(yylval*10)+(yytext[2]-'0');
  return YREG;
}

 /* PARTICULAR, "NON STANDARD" KEYWORDS: */
#[ \t]*NESTED_COMMENTS { enable_nested_comments = 1000; }
#[ \t]*NO_NESTED_COMMENTS { enable_nested_comments = 0; }
#[ \t]*EOF  { return 0; /* simulate an end of file */ }

/*
ENDIANNESS :
#[ \t]*ENDIAN 


*/

 /***********
  *         *
  * INCLUDE *
  *         *
  ***********/

#[ \t]*INCLUDE[ \t]*  { BEGIN(incl); }

<incl>\".*\"  {
  register struct include_node *_p;

/* fixes the file name, removing a " */
  yytext[--yyleng]=0;  /* ASCIIZ */

/* we check here if the file has already been included sothat we can avoid "loops": */
  _p=include_prec;   /* tail of the linked list */

  /* this is a while(){} because it allows to include a file named "stdin" without error */
  /* otherwise, recursive inclusions of the main file will be caught at the second pass */
    /* anyway, i renamed it after to "<stdin>" and it's a naughty hack... but it works. */
  while (_p->next != _p) /* head ? */
  {
/* string comparison */
    if (strcmp(_p->filename,yytext+1)==0)
      ygasm_error("can't recurse inclusions",NULL);
    _p = _p->next;
  }

/* eats the rest of the line */
  while (input()!='\n');

/* backing up */
  _p=ygasm_malloc(sizeof(struct include_node)+yyleng+1);
  include_prec->node_line_number = Line_Number;

/* opens the file */
  if ((_p->input_file=fopen(yytext+1,"rb"))==NULL)
  {
    yytext[0]='`';
    strcpy(yytext+yyleng,"' can't be opened");
    ygasm_error(yytext,NULL);
  }

  memcpy(_p->filename,yytext+1,yyleng);
  _p->next = include_prec;
  include_prec=_p;

  Line_Number = 1;
  BEGIN(INITIAL);
}

<incl>[^"] {  ygasm_error("wrong parameter for #INCLUDE",NULL);  }

/*

#[ \t]*INCBIN[ \t]*  { BEGIN(incl); }

*/

 /************
  *          *
  *  DEFINE  *
  *          *
  ************/

#[ \t]*DEFINE[ \t]*  { BEGIN(def1); }

<def1>{ID} {
  char c,*d,e;
  int buffer_size=0,
      limit=16;

  if (define_exists(yytext,yyleng))
    ygasm_warning (strcat(yytext," already defined"),NULL);

  d=malloc(limit);  /* hoping it is enough */

/* reads the definition */
  do
  {
    c=input();
/* tries to find a new line */
    if (c=='\\')
    {
      e=input();
      if (e!='\n')
      {
        d[buffer_size++]=c;
        if (buffer_size>=limit)
          if ((d=realloc(d,1+(limit+=256)))==NULL)
            ygasm_error("memory exhausted",NULL);
      }
      c=e;
    }
    d[buffer_size++]=c;

    if (buffer_size>=limit)
      if ((d=realloc(d,1+(limit+=256)))==NULL)
        ygasm_error("memory exhausted",NULL);
  }
  while (c!='\n');

  create_define(yytext,yyleng,d,buffer_size);

  BEGIN(INITIAL);
}

<def1>[^_a-zA-Z]  { ygasm_error ("only identifiers can be defined",NULL); }

/*
missing :
#[ \t]*IF[ \t]*
*/

 /*************
  *           *  This crap seems to work in most common cases
  *   IFDEF   *  but is not absolutely 100% reliable with very
  *           *  complex structures (no check is performed on
  *************  the skipped parts). Well, at l(e)ast it works. */

#[ \t]*IFDEF[ \t]*  { BEGIN(ifdef); }

<ifdef>{ID} {
  ifdef_count++;
  if (ifdef_count>=MAX_IFDEF)
    ygasm_error("too many #IF(N)DEF",NULL);
  else_count=(else_count << 1)|1;
  if (define_exists(yytext,yyleng))
    BEGIN(INITIAL); /* execute */
  else
    BEGIN(skip); /* skips until #ELSE or #ENDIF */
}

#[ \t]*IFNDEF[ \t]*  { BEGIN(ifndef); } /* Almost the same as above... could even be merged */

<ifndef>{ID} {
  ifdef_count++;
  if (ifdef_count>=MAX_IFDEF)
    ygasm_error("too many #IF(N)DEF",NULL);
  else_count=(else_count << 1)|1; /* "pushes" a flag */
  if (!define_exists(yytext,yyleng))
    BEGIN(INITIAL); /* execute */
  else
    BEGIN(skip); /* skips until #ELSE or #ENDIF */
}

<ifndef,ifdef>[^_a-zA-Z]  { ygasm_error ("only identifiers can be tested",NULL); }

<skip>#[ \t]*IFDEF { /* nested conditional defines */
  skip_count++;
}

<skip>#[ \t]*IFNDEF { /* nested conditional defines */
  skip_count++;
}

<skip>#[ \t]*ENDIF {
  if (skip_count>0) /* if skipping, simply nest.... */
    skip_count--;
  else
  {    /* end skipping */
    ifdef_count--;
    else_count>>=1; /* "pops" the else flag off the stack */
    BEGIN(INITIAL); /* execute */
  }
}

<skip>#[ \t]*ELSE {
  if (skip_count==0) /* if end of skipping */
  {
    if ((else_count & 1)!=1) /* if #ELSE not allowed*/
      ygasm_error("unexpected #ELSE",NULL);
    else_count=else_count & ~1; /* masks LSB out: no more #ELSE allowed*/
    BEGIN(INITIAL); /* execute */
  }
  /* else... nothing. */
}
<skip>.      { /* just */ }
<skip>\n     { /* skip */ }

#[ \t]*ELSE {
  if ((else_count & 1)!=1)
    ygasm_error("unexpected #ELSE",NULL);
  else_count=else_count & ~1; /* masks LSB out*/
  BEGIN(skip); /* skip */
}

#[ \t]*ENDIF {
  if (ifdef_count<1)
    ygasm_error("unexpected #ENDIF",NULL);
  else_count>>=1; /* "pops" the flag out of the stack */
  ifdef_count--; /* execute */
}

 /*
#[ \t]*UNDEF {
  ygasm_error("  #UNDEF not yet supported", NULL);
}
  */

 /*
  *  NUMBERS (Beware of the sizeof(int)!!!)
  */

B#[01]{1,64}  { /* evaluates the binary value */
  register int a=3;
  yylval=yytext[2] & 1;
  while (a<yyleng)
    yylval=(yylval<<1)|(yytext[a++] & 1);
  return YNUM;
}

0[0-7]{0,22}  { /* evaluates the octal value */
  register int a=1;
  yylval=yytext[0] & 7;
  while (a<yyleng)
    yylval=(yylval<<3)|(yytext[a++] & 7);
  return YNUM;
}

[1-9][0-9]{0,20}  { /* evaluates the decimal value */
  register int a=1;
  yylval=yytext[0]-'0';
  while (a<yyleng)
    yylval=(yylval*10)+(yytext[a++]-'0');
  return YNUM;
}

(0x|H#)[0-9a-fA-F]{1,16}  { /* evaluates the hexadecimal value */
  register int a=3;
  yylval=hex2int(yytext[2]);
  while (a<yyleng)
    yylval=(yylval<<4)|hex2int(yytext[a++]);
  return YNUM;
}

 /* insert your FP conversion here (and then send it to me :-D) */

 /*
  *  LABELS AND IDENTIFIERS
  */

{ID}    { 
  register struct define_node *_q;

/* test if it's already defined */
  register symbol *_p=symbol_exists(yytext,yyleng);

  if (_p!=NULL) {
    referenced_symbol=_p;
    yylval=_p->value;
    return YSYMB;
  }

/* test if it's already "#define"d */
  if ((_q = define_exists(yytext,yyleng))!=NULL) {
/* prevents "loops" */
    if (_q->char_counter != -1)
      ygasm_error ("can't recurse #DEFINEs",NULL);
/* switch to defined buffer */
    if (scan_from_define)
      _q->last_scan=current_define;
    else
      _q->last_scan=NULL;
    scan_from_define=1;
    _q->char_counter=0;
    current_define=_q;
/* prevents a buffer clash by saving the read character */
    _q->buffer[_q->buffer_size]=input();
  }

/* no -> return an unitinialised symbol */
  referenced_symbol=create_symbol(yytext,yyleng,0);
  return YNEWSYMB;
}

[ \n\t\f\x0B\x0C\x0D]   { /* eat up simple spaces and naughty characters */ }

. { return yytext[0]; }

%%

/* must be moved to ygasm_cmdl.c */
void init_flex(int argc, char **argv) {
  char * fname = argv[1];

  yyin=stdin;
  out_file=stdout;

  create_define("YGASM",5,"0.006",5);

  if (argc > 1) {  /* file mode */
    include_prec=(struct include_node *)ygasm_malloc(sizeof(*include_prec)+strlen(fname)+1);
    strcpy(include_prec->filename,fname);
    if ((include_prec->input_file = fopen(fname, "rb" ))== NULL)
      ygasm_error("can't open source file",NULL);
  }
  else {  /* interactive mode (input and output through the console) */
    include_prec=(struct include_node *)ygasm_malloc(sizeof(*include_prec)+7+1);
    strcpy(include_prec->filename,"<stdin>");
    include_prec->input_file=stdin;
  }

  if (argc > 2) {
	out_file = fopen(argv[2],"wb" );
	if (out_file == NULL)
	  ygasm_error("can't open destination file",NULL);
  }
  else
	ygasm_warning("sending binary stream to the console",NULL);

/* closes the linked list */
  include_prec->next = include_prec;
}
