-----------------------------------------------------------------------
-- f-cpu/vhdl/scheduler/scheduler_slot.vhdl
-- Describes one SQ slot of the FC0
-- Copyright (C) 2001 Yann GUIDON (whygee@f-cpu.org)
-- created lun dec 17 21:03:25 GMT 2001 by whygee@f-cpu.org
--
--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENSE------------------------------
--
-- First revision : let's see if it works :-)
--
-----------------------------------------------------------------------


LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
LIBRARY work;
    USE work.scheduler_definitions.ALL;
    USE work.random.ALL;


entity scheduler_slot is
  port (
    clk, reset       : in  Std_ulogic;
    data_in          : in  t_SQ_slot;
    R1, R2, R3       : in  Std_ulogic_vector(5 downto 0);
    --
    data_out         : out t_SQ_slot;
    R1_busy, R2_busy,
    R3_busy, R4_busy : out Std_ulogic);
end scheduler_slot;

architecture first_try of scheduler_slot is
  -- the following signal represents the register :
  signal slot_register : t_SQ_slot :=  (R1 => rand(6), R2 => rand(6),
    V1 => rand, V2 => rand,  EU1=> rand(4), EU2=> rand(4));
  -- some temporary variables for the comparisons :
  signal t1, t2 : Std_ulogic;

begin  -- first_try

  -- connexion of the output
  data_out <= slot_register;

  -- 1) implement the FIFO :
  -- start with the data that must be reset
  fifo_reset: process (clk) is
  begin
    if rising_edge(clk) then
      if reset = '1' then
        slot_register.V1 <= '0';  -- disable the slots
        slot_register.V2 <= '0';
      else
        slot_register.V1 <= data_in.V1;
        slot_register.V2 <= data_in.V2;
      end if;
    end if;
  end process fifo_reset;

  -- the rest of the queue :
  fifo_noreset: process (clk) is
  begin
    if rising_edge(clk) then
      slot_register.R1 <= data_in.R1;
      slot_register.R2 <= data_in.R2;
      slot_register.EU1 <= data_in.EU1;
      slot_register.EU2 <= data_in.EU2;
    end if;
  end process fifo_noreset;


  -- comparisons
  R1_busy <= '1' when ((slot_register.V1 ='1') and (R1 = slot_register.R1))
                  or  ((slot_register.V2 ='1') and (R1 = slot_register.R2))
             else '0';

  R2_busy <= '1' when ((slot_register.V1 ='1') and (R2 = slot_register.R1))
                  or  ((slot_register.V2 ='1') and (R2 = slot_register.R2))
             else '0';

  t1 <= '1' when ((slot_register.V1 ='1') and (R3(5 downto 1) = slot_register.R1(5 downto 1)))
        else '0';
  t2 <= '1' when ((slot_register.V2 ='1') and (R3(5 downto 1) = slot_register.R2(5 downto 1)))
        else '0';
         
  R3_busy <= '1' when ((t1 ='1') and (R3(0) = slot_register.R1(0)))
                  or  ((t2 ='1') and (R3(0) = slot_register.R2(0)))
             else '0';

  R4_busy <= '1' when ((t1 ='1') and (R3(0) = not slot_register.R1(0)))
                  or  ((t2 ='1') and (R3(0) = not slot_register.R2(0)))
             else '0';
  

end first_try;
