-- popc.vhdl - Bit-Counting Execution Unit for the F-CPU.
-- 
-- copy/pasted Sun Jun 30 06:22:15 CEST 2002 by whygee@f-cpu.org
-- from Michael's f-cpu/eu_shl/shl.vhdl
-- $Id: shl.vhdl,v 1.1 2002/05/13 18:26:00 michael Exp $
-- Copyright (C) 2000 - 2002 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-- Remark about the MSB clear : since popcount(0)=0, no need of any specific
-- masking logic.


library IEEE;
use IEEE.std_logic_1164.all;

library work;
use work.FCPU_config.all;
use work.popc64;

entity EU_POPC is
  port(
    -- operands
    Din_0,               -- main input
    Din_1 : in F_VECTOR; -- alternate input (XOR)
    -- SIMD mode bits (decoded)
    Size             : in std_ulogic_vector(2 downto 0);
    -- -- clock/enable inputs (unused)
    -- Clk, En : in std_ulogic;

    -- output
    Dout : out F_VECTOR
  );
end EU_POPC;

architecture Struct_1 of EU_POPC is
  -- internal unit width (only 64 is supported right now)
  constant w : natural := MAX_CHUNK_SIZE;
begin
--pragma synthesis_off
  assert w = 64
    report "MAX_CHUNK_SIZE must be 64"
    severity failure;
--pragma synthesis_on

  -- A row of bit counters :
  instantiate : for i in UMAX/w-1 downto 0 generate
    core : entity popc64
      generic map (
        WIDTH => w
        -- missing : pipelining
      )
      port map (
        POPC_in_A => Din_0(w*i+w-1 downto w*i),
        POPC_in_B => Din_1(w*i+w-1 downto w*i),
        POPC_size => Size,
--        Clk       => Clk,
        POPC_out  => Dout
      );
  end generate;
end Struct_1;

