--------------------------------------------------------------------------
-- File vhdl/eu_inc/eu_inc.vhdl - INC Unit Execution
-- Copyright (C) 2002 Etienne Labarre (etienne.labarre@gadz.org)
--
-- Sun Jun 30 13:09:23 CEST 2002
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- SIMD MODES
-- see file find_lsb.vhdl
-- 
-- OPERATIONS MODE
-- eu_inc_mode operation test
-- 00      NEG       
-- 11      INC       
-- 10      DEC       
--
--------------------------------------------------------------------------

-- include standard libraries
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.all;

-- include project libraries
LIBRARY work;
USE work.find_lsb;

-- Definition of EU_INC entity
entity eu_inc is
   generic ( eu_inc_width : natural := 6 );
   port (
      -- Input
      eu_inc_A    : in  std_ulogic_vector(2**eu_inc_width-1 downto 0);
      eu_inc_B    : in  std_ulogic_vector(2**eu_inc_width-1 downto 0);
      -- SIMD mode switches
      eu_inc_simd : in  std_ulogic_vector(eu_inc_width-1 downto 0);
      -- operations
      eu_inc_mode : in  std_ulogic_vector(1 downto 0);
      -- output
      eu_inc_Y    : out std_ulogic_vector(2**eu_inc_width-1 downto 0)
      );
end eu_inc;

-- Description of EU_INC entity
architecture simple of eu_inc is

   signal tree_in   : std_ulogic_vector(2**eu_inc_width-1 downto 0);
   signal tree_out  : std_ulogic_vector(2**eu_inc_width-1 downto 0);

begin
   -- Component fbit
   tree_fbit : entity find_lsb
      generic map( find_lsb_width => eu_inc_width )
      port map(
         find_lsb_input  => tree_in,
         find_lsb_output => tree_out,
         find_lsb_simd   => eu_inc_simd
         );

     -- Input of unit
     with eu_inc_mode(0) select
	tree_in <= 
	   not eu_inc_A when '0',
	   eu_inc_A     when others;
    
     -- Output of unit
     with eu_inc_mode(1) select
        eu_inc_Y <= 
	   not tree_out xor eu_inc_A when '0',
	   tree_out xor eu_inc_A     when others;
end;
