/*
 * fromfs_lib.c
 * created sam mar 16 04:13:35 GMT 2002 by whygee@f-cpu.org
 *
 * This file includes some C-code which is included
 * (in F-CPU ASM) in the Flash for booting the fromfs system.
 *
 */

/* file I/O + error messages */
#include <stdio.h>

/* memcmp */
#include <string.h>

/* custom defs */
#include "fromfs.h"

#if __BYTE_ORDER != __LITTLE_ENDIAN
#error "only little endian is currently supported"
#endif

/* necessary. */
/* This will probably be implemented as a syscall/trap.
void fromfs_error(char *msg) {
  printf("\nFromFS error :");
  printf(msg);
  exit(40);
} */


/* walks the directory entries of fromfs_base,
   searches a specified file name,
   returns the address of the corresponding entry,
   zero if not found. */
void * fromfs_locate(void * fromfs_base,
  unsigned long long int n1,  /* computed name chunk 1 */
  unsigned long long int n2,  /* computed name chunk 2 */
  unsigned long int      n3   /* computed name chunk 3 */
) {
  /* these variables will be assigned to other registers : */
  unsigned long long int
    t1,  /* read name chunk 1 */
    t2;  /* read name chunk 2 */
  unsigned long int
    c1,  /* loop count */
    t3;  /* read name chunk 3 */
  void
    * return_value,
    * i1,  /* index to name chunk 1 */
    * i2,  /* index to name chunk 2 */
    * i3;  /* index to name chunk 3 */

  (char *)i1 = (char *)fromfs_base + offset_dir_entries;
  c1 = *(unsigned long int *)i1;

  /* first, let's assume that a "directory" is never empty.
     In case not (otherwise it's useless but this may happen),
     use the following code : */
#ifndef no_size_check
  return_value = NULL; /* error */
  if (c1 == 0)
    return return_value;
#endif

  (char *)i1 = (char *)fromfs_base + size_fromfs_header;    /* loadaddr */
  (char *)i2 = (char *)fromfs_base + size_fromfs_header + 8;
  (char *)i3 = (char *)fromfs_base + size_fromfs_header + 16;

L1: /* loopentry L1 */
    c1 --; /* the loop instruction requires it */
    return_value = i1;
    t1 = *(unsigned long long int *)i1;  i1 += size_fromfs_entry;
    t2 = *(unsigned long long int *)i2;  i2 += size_fromfs_entry;
    t3 = *(unsigned long      int *)i3;  i3 += size_fromfs_entry;
    t1 ^= n1;
    t2 ^= n2;
    t3 ^= n3;
    t1 |= t2;
    (unsigned long int) t1 |= t3;
    if (t1 == 0LL)
      return return_value; /* cond. jump to calling register */
    /* loop instruction : */
    if (c1 != 0L)
      goto L1;

  return_value = 0;
  return return_value;
}

/* a C version, less easily translatable to F-CPU */
void * locate_dir(char * name, void * base) {
  unsigned long int dir_size, dir_entries;
  void * p;
  int i;
  char n[20];

  /* just in case */
  if (base == NULL)
    return NULL;

  /* build the name */
  memset(n,0,20);
  n[0] = strnlen(name,19);
  memcpy(&n[1],name,n[0]);

  p = fromfs_locate(base,
    *(unsigned long long int *)n,
    *(unsigned long long int *)(n+8),
    *(unsigned long      int *)(n+16));

  if (p == NULL) {
    printf(n+1);
    printf(" not found\n");
    return base;
  }

  return p;
}
