/*
f-cpu/ygasm/ygasm_bin.c
created Sun Jul 15 19:35:30 by Yann Guidon <whygee@f-cpu.org>

this part controls the generation of the binary output stream.
I have forgotten where the GRAZER is, it already contained some nice
stuff, but i'm rewriting it anyway.

The forward label declaration feature is missing.

version : Thu Aug  2 04:41:49 2001
changed the instruction format : field offsets are now reversed
started to include the outbin feature (at the bottom of this file)

*/

#define BIN_BUFF_SIZE 1024

u8 imm8, opcode, reg_src1, reg_src2, reg_dest, SIMD_flag;
u16 imm16;
u32 current_instruction;
unsigned int current_pos, current_PC;
u8 bin_buffer[BIN_BUFF_SIZE];


void init_out_buff() {
  imm8 = 0;
  opcode =0;
  reg_src1 = 0;
  reg_src2 = 0;
  reg_dest = 0;
  imm16 = 0;
  current_instruction = 0;
  current_pos= 0;
  SIMD_flag = 0;
}

void emit_byte(u8 b) {
  bin_buffer[current_pos++] = b;
  if (current_pos >= BIN_BUFF_SIZE) {
    /* flush the buffer */
    fwrite(bin_buffer,1,BIN_BUFF_SIZE,out_file);
    current_pos = 0;
  }
  current_PC ++;  
}

void emit_instruction() {
  if ((current_PC & 3) != 0) {
    ygasm_error("yuk ! the instruction is not aligned on a 4-byte boundary",NULL);
  }

  /* the different fields are collected : */

  /* JWS: testing: printf("current_instruction=%8X ",current_instruction); */ 

  /* JWS opcode is not used !!, opcode is already in current_instruction !!!!*/
  current_instruction |=
      ( opcode    << 24) 
    | ( SIMD_flag << 21)
    | ( reg_src1  << 12)
    | ( imm8      << 12)
    | ( imm16     << 6)
    | ( reg_src2  << 6)
    |   reg_dest;

 /* JWS: testing: printf("current_instruction=%8X\n",current_instruction); */

#ifdef INSTRUCTION_BIG_ENDIAN
  /* send the int in the correct endianness */
  emit_byte((current_instruction >> 24) & 0xFF);
  emit_byte((current_instruction >> 16) & 0xFF);
  emit_byte((current_instruction >> 8)  & 0xFF);
  emit_byte( current_instruction        & 0xFF);
#else
  /* little endian */
  emit_byte((current_instruction) & 0xFF);
  emit_byte((current_instruction >> 8) & 0xFF);
  emit_byte((current_instruction >> 16)  & 0xFF);
  emit_byte((current_instruction >> 24)  & 0xFF);
#endif

  /* reset for the next round : */
  SIMD_flag = 0;
  imm8 = 0;
  opcode = 0;
  reg_src1 = 0;
  reg_src2 = 0;
  reg_dest = 0;
  imm16 = 0;
  /* JWS: as the opcede is returned in current_instruction, we must clear that to !! */
  current_instruction = 0;
}


void flush_out_buff() {
  fwrite(bin_buffer,1,current_pos,out_file);
  fclose(out_file);
}

void align_pc(u64 a) {
  u64 b;

  if ((a < 2) || (a > 10000)) {  /* reality check, or if the boundary is negative */
    ygasm_error("wrong alignment boundary range",NULL);
  }
  if ((a & -a)!= a) { /* check if the parameter is a power of two */
    ygasm_error("alignment to a boundary not power of two",NULL);
  }

  b = a-1; /* make the mask, ie : a= 0x10 => b= 0xF */

  while ((current_PC & b)!=0) {
    emit_byte (0);
  }

  /* support for "align" real instruction could be added but
     no specification is available now. */

}


#ifdef DONT_USE
 This part is unused, until i add support for this feature in the flex file.
void new_outfile () {

  /* first : close the old file */
  flush_out_buff();

  /* second : open the new file */
  init_out_buff();

  out_file = fopen(,"wb" );
  if (out_file == NULL)
    ygasm_error("can't open destination file",NULL);

}
#endif
